/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.sampletextfile;

import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public abstract class SampleTextFile {
    protected String inputFileName;
    protected String outputFileName;
    protected double sample;

    public SampleTextFile(String inputFileName, String outputFileName, double sample) {
        this.inputFileName = inputFileName;
        this.outputFileName = outputFileName;
        this.sample = sample;
        this.setupSampling();
    }

    public SampleTextFile(String inputFileName, String outputFileName, int sample) {
        this(inputFileName, outputFileName, (double)sample);
    }

    protected void setupSampling() {
    }

    public void sample() {
        try {
            UnicodeReader streamReader = new UnicodeReader(new FileInputStream(new File(this.inputFileName)), "utf-8");
            BufferedReader in = new BufferedReader(streamReader);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFileName, true), "utf-8"));
            String inputLine = in.readLine();
            while (inputLine != null && !this.samplingDone()) {
                if (this.lineSelected(inputLine)) {
                    printWriter.println(inputLine);
                }
                inputLine = in.readLine();
            }
            in.close();
            printWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("   *** Failed");
        }
    }

    protected abstract boolean lineSelected(String var1);

    public boolean samplingDone() {
        return false;
    }
}

