/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.mergewordlists;

import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.SetUtils;
import java.util.Set;
import java.util.TreeSet;

public class MergeWordLists {
    protected static Set<String> mergedWordSet = new TreeSet<String>();

    public static void main(String[] args) {
        int i;
        String[] fileNames = new String[args.length - 1];
        for (i = 1; i < args.length; ++i) {
            fileNames[i - 1] = args[i];
        }
        fileNames = FileNameUtils.expandFileNameWildcards(fileNames);
        for (i = 0; i < fileNames.length; ++i) {
            try {
                MergeWordLists.loadAndMergeWords(fileNames[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            MergeWordLists.saveMergedWords(args[0]);
        }
        catch (Exception e) {
            System.out.println("Unable to save merged words.");
        }
    }

    protected static void loadAndMergeWords(String inputFileName) throws Exception {
        Set<String> set = SetUtils.loadSet(inputFileName, "utf-8");
        System.out.println("Merging " + set.size() + " words from " + inputFileName);
        mergedWordSet.addAll(set);
    }

    protected static void saveMergedWords(String outputFileName) throws Exception {
        System.out.println("Saving " + mergedWordSet.size() + " words to " + outputFileName);
        SetUtils.saveSet(mergedWordSet, outputFileName, "utf-8");
    }

    protected MergeWordLists() {
    }
}

