/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.comparestringcounts;

import edu.northwestern.at.morphadorner.corpuslinguistics.statistics.Frequency;
import edu.northwestern.at.utils.Compare;
import edu.northwestern.at.utils.CountMapUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.InvalidDataException;
import edu.northwestern.at.utils.ScoredString;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CompareStringCounts {
    public static void main(String[] args) {
        if (args.length >= 2) {
            new CompareStringCounts(args);
        } else {
            CompareStringCounts.displayUsage();
            System.exit(1);
        }
    }

    public static void displayUsage() {
        System.out.println("");
        System.out.println("Compare string counts in two files using Dunning's log-likelihood.");
        System.out.println("Usage: ");
        System.out.println("");
        System.out.println("   java edu.northwestern.at.morphadorner.tools.comparestringcounts.CompareStringCounts analysis.tab reference.tab");
        System.out.println("");
        System.out.println("analysis.tab -- Input tab-separated file of strings and counts for an analysis text.");
        System.out.println("reference.tab -- Input tab-separated file    of strings and counts for a reference text.");
        System.out.println("");
    }

    public CompareStringCounts(String[] args) {
        boolean inputDataOK = true;
        Map<String, Number> analysisCounts = null;
        try {
            analysisCounts = CountMapUtils.loadCountMapFromFile(new File(args[0]));
        }
        catch (IOException e) {
            System.err.println("Unable to read analysis counts file " + args[0] + ": " + e.getMessage());
            inputDataOK = false;
        }
        catch (InvalidDataException e) {
            System.err.println("The analysis counts file " + args[0] + " contains errors.");
            System.err.println();
            List<String> errors = e.getMessages();
            for (String error : errors) {
                System.err.println("   " + error);
            }
            inputDataOK = false;
        }
        Map<String, Number> referenceCounts = null;
        try {
            referenceCounts = CountMapUtils.loadCountMapFromFile(new File(args[1]));
        }
        catch (IOException e) {
            System.err.println("Unable to read reference counts file " + args[1] + ": " + e.getMessage());
            inputDataOK = false;
        }
        catch (InvalidDataException e) {
            System.err.println("The reference counts file " + args[0] + " contains errors.");
            System.err.println();
            List<String> errors = e.getMessages();
            for (String error : errors) {
                System.err.println("   " + error);
            }
            inputDataOK = false;
        }
        if (!inputDataOK) {
            System.err.println("Quitting because of input errors.");
            System.exit(1);
        }
        int analysisTotalCount = CountMapUtils.getTotalWordCount(analysisCounts);
        int refTotalCount = CountMapUtils.getTotalWordCount(referenceCounts);
        System.err.println("Comparing string counts using " + args[0] + " as analysis file and " + args[1] + " as reference file.");
        System.err.println("");
        System.err.println("Analysis unique strings  : " + analysisCounts.size());
        System.err.println("Analysis total strings   : " + analysisTotalCount);
        System.err.println("Reference unique strings : " + referenceCounts.size());
        System.err.println("Reference total strings  : " + refTotalCount);
        Map<String, Number> combinedCounts = CountMapUtils.semiDeepClone(analysisCounts);
        CountMapUtils.addCountMap(combinedCounts, referenceCounts);
        TreeMap<ReverseScoredString, double[]> results = new TreeMap<ReverseScoredString, double[]>();
        Set<String> keySet = combinedCounts.keySet();
        int stringsDone = 0;
        for (String stringToAnalyze : keySet) {
            Number stringCount = analysisCounts.get(stringToAnalyze);
            if (stringCount == null) {
                stringCount = new Integer(0);
            }
            int refCount = 0;
            if (referenceCounts.containsKey(stringToAnalyze)) {
                refCount = referenceCounts.get(stringToAnalyze).intValue();
            }
            double[] freqAnal = CompareStringCounts.doFreq(stringToAnalyze, stringCount.intValue(), analysisTotalCount, refCount, refTotalCount);
            results.put(new ReverseScoredString(stringToAnalyze, freqAnal[4]), freqAnal);
            ++stringsDone;
        }
        CompareStringCounts.displayResults(results);
    }

    public static double[] doFreq(String stringToAnalyze, int analysisCount, int analysisTotalCount, int refCount, int refTotalCount) {
        double[] freqAnal = Frequency.logLikelihoodFrequencyComparison(analysisCount, refCount, analysisTotalCount, refTotalCount, false);
        freqAnal[1] = freqAnal[1] * 100.0;
        freqAnal[3] = freqAnal[3] * 100.0;
        return freqAnal;
    }

    public static void displayResults(Map<ReverseScoredString, double[]> results) {
        System.out.println("String\tOver/under use\tLog likelihood\tAnalysis percent\tReference percent\tAnalysis count\tReference count");
        for (ReverseScoredString key : results.keySet()) {
            double[] freqAnal = results.get(key);
            String overUnderUse = Compare.compare(freqAnal[1], freqAnal[3]) > 0 ? "+" : "-";
            int places = 2;
            System.out.println(key.getString() + "\t" + overUnderUse + "\t" + Formatters.formatDouble(freqAnal[4], places) + "\t" + Formatters.formatDouble(freqAnal[1], places) + "\t" + Formatters.formatDouble(freqAnal[3], places) + "\t" + Formatters.formatDouble(freqAnal[0], 0) + "\t" + Formatters.formatDouble(freqAnal[2], 0));
        }
    }

    public static class ReverseScoredString
    extends ScoredString {
        public ReverseScoredString(String string, double score) {
            super(string, score);
        }

        @Override
        public int compareTo(Object other) {
            return -super.compareTo(other);
        }
    }
}

