/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.compareadornedfiles;

import edu.northwestern.at.morphadorner.tools.compareadornedfiles.FieldType;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.WordChange;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.Compare;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.xml.JDOMUtils;
import edu.northwestern.at.utils.xml.jdom.ElementsFilter;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.jdom2.util.IteratorIterable;

public class MutableAdornedFile {
    protected Map<String, Element> adornedWordMap = MapFactory.createNewLinkedMap(10000);
    protected List<String> wordIDs = ListFactory.createNewList(10000);
    protected Set<String> wordTagsSet = SetFactory.createNewSet();
    protected Document document;
    protected static Namespace teiNamespace = Namespace.getNamespace((String)"http://www.tei-c.org/ns/1.0");

    public MutableAdornedFile(String adornedFileName, String[] wordTags) throws Exception {
        this.wordTagsSet.addAll(Arrays.asList(wordTags));
        this.document = JDOMUtils.parse(new File(adornedFileName));
        ElementsFilter filter = new ElementsFilter(wordTags);
        Element root = this.document.getRootElement();
        IteratorIterable iterator = root.getDescendants((Filter)filter);
        while (iterator.hasNext()) {
            Element wordElement = (Element)iterator.next();
            String id = JDOMUtils.getAttributeValue(wordElement, "xml:id", false);
            this.wordIDs.add(id);
            this.adornedWordMap.put(id, wordElement);
        }
    }

    public MutableAdornedFile(String adornedFileName) throws Exception {
        this(adornedFileName, new String[]{"w", "pc"});
    }

    public List<String> getAdornedWordIDs() {
        return this.wordIDs;
    }

    public Element getAdornedWord(String id) {
        return this.adornedWordMap.get(id);
    }

    public Document getDocument() {
        return this.document;
    }

    public void applyChange(WordChange change) {
        String id = change.id;
        switch (change.changeType) {
            case addition: {
                if (change.fieldType == FieldType.text) {
                    this.addWordElement(id, change.siblingID, change.newValue, change.blankPrecedes);
                    break;
                }
                if (change.fieldType != FieldType.attribute) break;
                this.setWordElementAttribute(id, change.attributeName, change.newValue);
                break;
            }
            case modification: {
                if (change.fieldType == FieldType.text) {
                    this.setWordElementText(id, change.newValue);
                    break;
                }
                if (change.fieldType != FieldType.attribute) break;
                this.setWordElementAttribute(id, change.attributeName, change.newValue);
                break;
            }
            case deletion: {
                if (change.fieldType == FieldType.text) {
                    this.deleteWordElement(id);
                    break;
                }
                if (change.fieldType != FieldType.attribute) break;
                this.deleteWordElementAttribute(id, change.attributeName);
            }
        }
    }

    public void revertChange(WordChange change) {
        String id = change.id;
        switch (change.changeType) {
            case deletion: {
                if (change.fieldType == FieldType.text) {
                    this.addWordElement(id, change.siblingID, change.oldValue, change.blankPrecedes);
                    break;
                }
                if (change.fieldType != FieldType.attribute) break;
                this.setWordElementAttribute(id, change.attributeName, change.oldValue);
                break;
            }
            case modification: {
                if (change.fieldType == FieldType.text) {
                    this.setWordElementText(id, change.oldValue);
                    break;
                }
                if (change.fieldType != FieldType.attribute) break;
                this.setWordElementAttribute(id, change.attributeName, change.oldValue);
                break;
            }
            case addition: {
                if (change.fieldType == FieldType.text) {
                    this.deleteWordElement(id);
                    break;
                }
                if (change.fieldType != FieldType.attribute) break;
                this.deleteWordElementAttribute(id, change.attributeName);
            }
        }
    }

    public void applyChanges(List<WordChange> changes) {
        for (int i = 0; i < changes.size(); ++i) {
            this.applyChange(changes.get(i));
        }
        this.compressCElements();
    }

    public void revertChanges(List<WordChange> changes) {
        for (int i = 0; i < changes.size(); ++i) {
            this.revertChange(changes.get(i));
        }
        this.compressCElements();
    }

    protected Element createElement(String name) {
        return new Element(name, teiNamespace);
    }

    protected boolean deleteWordElement(String id) {
        boolean result = false;
        Element wordElement = this.adornedWordMap.get(id);
        if (wordElement != null) {
            Element parent = wordElement.getParentElement();
            int wordIndex = parent.indexOf((Content)wordElement);
            result = parent.removeContent((Content)wordElement);
            if (result) {
                this.adornedWordMap.remove(id);
                this.wordIDs.remove(id);
            }
        }
        return result;
    }

    public void deleteWordElementAttribute(String id, String attrName) {
        Element wordElement = this.adornedWordMap.get(id);
        if (wordElement != null && attrName != null) {
            JDOMUtils.removeAttribute(wordElement, attrName);
        }
    }

    public void setWordElementText(String id, String text) {
        Element wordElement = this.adornedWordMap.get(id);
        if (wordElement != null && text != null) {
            wordElement.setText(text);
        }
    }

    public void setWordElementAttribute(String id, String attrName, String attrValue) {
        Element wordElement = this.adornedWordMap.get(id);
        if (wordElement != null && attrName != null && attrValue != null) {
            JDOMUtils.setAttributeValue(wordElement, attrName, attrValue);
        }
    }

    protected void addWordElement(String id, String siblingID, String text, boolean blankPrecedes) {
        Element cElement;
        if (siblingID == null) {
            return;
        }
        Element sibling = this.adornedWordMap.get(siblingID);
        Element parent = sibling.getParentElement();
        int siblingIndex = parent.indexOf((Content)sibling);
        boolean addSpace = false;
        Element wordElement = CharUtils.isPunctuation(text) ? this.createElement("pc") : this.createElement("w");
        addSpace = blankPrecedes;
        wordElement.setText(text);
        JDOMUtils.setAttributeValue(wordElement, "xml:id", id);
        if (Compare.compare(id, siblingID) < 0) {
            parent.addContent(siblingIndex, (Content)wordElement);
            if (addSpace) {
                cElement = this.createElement("c");
                cElement.setText(" ");
                parent.addContent(siblingIndex, (Content)cElement);
            }
        } else {
            parent.addContent(siblingIndex + 1, (Content)wordElement);
            if (addSpace) {
                cElement = this.createElement("c");
                cElement.setText(" ");
                parent.addContent(siblingIndex + 1, (Content)cElement);
            }
        }
        this.adornedWordMap.put(id, wordElement);
        int index = this.wordIDs.indexOf(siblingID);
        if (index >= 0) {
            if (Compare.compare(id, siblingID) < 0) {
                this.wordIDs.add(index, id);
            } else {
                this.wordIDs.add(index + 1, id);
            }
        }
    }

    protected void compressCElements() {
        Filter filter = Filters.element();
        Element root = this.document.getRootElement();
        Element previousElement = null;
        IteratorIterable iterator = root.getDescendants(filter);
        List<Element> cToDelete = ListFactory.createNewList();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (previousElement != null && e.getName().equals("c") && e.getText().equals(" ") && previousElement.getName().equals("c") && previousElement.getText().equals(" ")) {
                cToDelete.add(e);
            }
            previousElement = e;
        }
        for (int i = 0; i < cToDelete.size(); ++i) {
            Element c = (Element)cToDelete.get(i);
            Parent parent = c.getParent();
            if (parent == null) continue;
            parent.removeContent((Content)c);
        }
    }
}

