/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.compareadornedfiles;

import com.thoughtworks.xstream.XStream;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.AdornedWordData;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.AdornedWordsLoader;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.FieldType;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.WordChange;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.WordChangeLog;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.WordChangeType;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.SetFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class CompareAdornedFiles {
    public CompareAdornedFiles(String oldAdornedFileName, String newAdornedFileName, String changesFileName, PrintStream printStream) throws Exception {
        AdornedWordData w;
        long startTime = System.currentTimeMillis();
        AdornedWordsLoader xmlReader = new AdornedWordsLoader(oldAdornedFileName);
        AdornedWordsLoader xmlReader2 = new AdornedWordsLoader(newAdornedFileName);
        long endTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        List<String> wordIDs = xmlReader.getAdornedWordIDs();
        List<String> wordIDs2 = xmlReader2.getAdornedWordIDs();
        printStream.println("Read " + Formatters.formatIntegerWithCommas(wordIDs.size()) + " words from " + oldAdornedFileName + ".");
        printStream.println("Read " + Formatters.formatIntegerWithCommas(wordIDs2.size()) + " words from " + newAdornedFileName + ".");
        startTime = System.currentTimeMillis();
        WordChangeLog changeLog = new WordChangeLog("Changes from " + FileNameUtils.stripPathName(oldAdornedFileName) + " to " + FileNameUtils.stripPathName(newAdornedFileName) + " as determined by CompareAdornedFiles.");
        int wordsModified = 0;
        int wordsAdded = 0;
        int wordsDeleted = 0;
        for (int wordOrd = 0; wordOrd < wordIDs.size(); ++wordOrd) {
            String wText2;
            String id = wordIDs.get(wordOrd);
            AdornedWordData w2 = xmlReader.getAdornedWordData(id);
            AdornedWordData w22 = xmlReader2.getAdornedWordData(id);
            if (w2 == null || w22 == null) continue;
            boolean wordTextModified = false;
            String wText = w2.getWordText();
            if (!wText.equals(wText2 = w22.getWordText())) {
                changeLog.addChange(new WordChange(id, WordChangeType.modification, FieldType.text, null, wText, wText2, null, w22.getBlankPrecedes()));
                wordTextModified = true;
            }
            boolean attributesModified = this.logAttributeDifferences(changeLog, id, w2, w22);
            if (!wordTextModified && !attributesModified) continue;
            ++wordsModified;
        }
        SortedSet<String> set1 = SetFactory.createNewSortedSet();
        set1.addAll(wordIDs);
        SortedSet<String> set2 = SetFactory.createNewSortedSet();
        set2.addAll(wordIDs2);
        SortedSet<String> deletedWords = SetFactory.createNewSortedSet();
        deletedWords.addAll(set1);
        deletedWords.removeAll(set2);
        SortedSet<String> addedWords = SetFactory.createNewSortedSet();
        addedWords.addAll(set2);
        addedWords.removeAll(set1);
        for (String id : deletedWords) {
            w = xmlReader.getAdornedWordData(id);
            String wText = w == null ? "" : w.getWordText();
            changeLog.addChange(new WordChange(id, WordChangeType.deletion, FieldType.text, null, wText, null, w.getSiblingID(), w.getBlankPrecedes()));
            this.logAttributeDeletions(changeLog, id, w);
        }
        wordsDeleted += deletedWords.size();
        for (String id2 : addedWords) {
            w = xmlReader2.getAdornedWordData(id2);
            changeLog.addChange(new WordChange(id2, WordChangeType.addition, FieldType.text, null, null, w.getWordText(), w.getSiblingID(), w.getBlankPrecedes()));
            this.logAttributeAdditions(changeLog, id2, w);
        }
        wordsAdded += addedWords.size();
        XStream xstream = new XStream();
        xstream.alias("change", WordChange.class);
        xstream.alias("ChangeLog", WordChangeLog.class);
        String xmlDiff = xstream.toXML((Object)changeLog);
        xmlDiff = xmlDiff.replaceAll("&apos;", "'");
        FileUtils.writeTextFile(new File(changesFileName), false, xmlDiff, "utf-8");
        endTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        printStream.println("Found " + Formatters.formatIntegerWithCommas(changeLog.getChanges().size()) + " changes in " + Formatters.formatLongWithCommas(endTime) + (endTime == 1L ? " second." : " seconds."));
        printStream.println("   " + Formatters.formatIntegerWithCommas(wordsModified) + (wordsModified == 1 ? " word " : " words ") + "modified.");
        printStream.println("   " + Formatters.formatIntegerWithCommas(wordsAdded) + (wordsAdded == 1 ? " word " : " words ") + "added.");
        printStream.println("   " + Formatters.formatIntegerWithCommas(wordsDeleted) + (wordsDeleted == 1 ? " word " : " words ") + "deleted.");
    }

    protected boolean logAttributeDifferences(WordChangeLog changeLog, String id, AdornedWordData w1, AdornedWordData w2) {
        boolean result = false;
        Map<String, String> w1Map = w1.getAttributeMap();
        Map<String, String> w2Map = w2.getAttributeMap();
        for (String attrName : w1Map.keySet()) {
            String attrValue1 = w1Map.get(attrName);
            String attrValue2 = w2Map.get(attrName);
            if (attrValue1 == null || attrValue2 == null || attrValue1.equals(attrValue2)) continue;
            changeLog.addChange(new WordChange(id, WordChangeType.modification, FieldType.attribute, attrName, attrValue1, attrValue2, null, w2.getBlankPrecedes()));
            result = true;
        }
        SortedSet<String> set1 = SetFactory.createNewSortedSet();
        set1.addAll(w1Map.keySet());
        SortedSet<String> set2 = SetFactory.createNewSortedSet();
        set2.addAll(w2Map.keySet());
        SortedSet<String> deletedAttributes = SetFactory.createNewSortedSet();
        deletedAttributes.addAll(set1);
        deletedAttributes.removeAll(set2);
        SortedSet<String> addedAttributes = SetFactory.createNewSortedSet();
        addedAttributes.addAll(set2);
        addedAttributes.removeAll(set1);
        for (String attrName : deletedAttributes) {
            changeLog.addChange(new WordChange(id, WordChangeType.deletion, FieldType.attribute, attrName, w1Map.get(attrName), null, null, w2.getBlankPrecedes()));
        }
        result = result || deletedAttributes.size() > 0;
        for (String attrName : addedAttributes) {
            changeLog.addChange(new WordChange(id, WordChangeType.addition, FieldType.attribute, attrName, null, w2Map.get(attrName), null, w2.getBlankPrecedes()));
        }
        result = result || addedAttributes.size() > 0;
        return result;
    }

    protected void logAttributeAdditions(WordChangeLog changeLog, String id, AdornedWordData w) {
        Map<String, String> wMap = w.getAttributeMap();
        for (String attrName : wMap.keySet()) {
            String attrValue = wMap.get(attrName);
            if (attrValue == null) continue;
            changeLog.addChange(new WordChange(id, WordChangeType.addition, FieldType.attribute, attrName, null, attrValue, null, w.getBlankPrecedes()));
        }
    }

    protected void logAttributeDeletions(WordChangeLog changeLog, String id, AdornedWordData w) {
        Map<String, String> wMap = w.getAttributeMap();
        for (String attrName : wMap.keySet()) {
            String attrValue = wMap.get(attrName);
            if (attrValue == null) continue;
            changeLog.addChange(new WordChange(id, WordChangeType.deletion, FieldType.attribute, attrName, attrValue, null, null, w.getBlankPrecedes()));
        }
    }

    public static void main(String[] args) {
        try {
            PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(System.out), true, "utf-8");
            if (args.length < 3) {
                printStream.println("Not enough parameters.");
                System.exit(1);
            }
            new CompareAdornedFiles(args[0], args[1], args[2], printStream);
            try {
                printStream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

