/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.adornedtosketch;

import edu.northwestern.at.morphadorner.tei.BibadornedInfo;
import edu.northwestern.at.morphadorner.tei.TEIHeaderAuthor;
import edu.northwestern.at.morphadorner.tei.TEIHeaderInfo;
import edu.northwestern.at.morphadorner.tools.AdornedXMLReader;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWord;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.SetFactory;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;

public class AdornedToSketch {
    protected static int docsToProcess = 0;
    protected static int currentDocNumber = 0;
    protected static String inputDirectory;
    protected static String outputFile;
    protected static PrintStream outputFileStream;
    protected static PrintStream printStream;
    protected static String corpusName;
    protected static final int INITPARAMS = 2;

    public static void main(String[] args) {
        try {
            if (!AdornedToSketch.initialize(args)) {
                System.exit(1);
            }
            long startTime = System.currentTimeMillis();
            int filesProcessed = AdornedToSketch.processFiles(args);
            long processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
            AdornedToSketch.terminate(filesProcessed, processingTime);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    protected static boolean initialize(String[] args) throws Exception {
        printStream = new PrintStream((OutputStream)new BufferedOutputStream(System.out), true, "utf-8");
        if (args.length < 3) {
            System.err.println("Not enough parameters.");
            return false;
        }
        outputFile = args[0];
        corpusName = args[1];
        return true;
    }

    protected static String[] splitPathFull(String path) {
        String[] tags = path.split("\\\\");
        String[] result = new String[tags.length - 1];
        int j = 0;
        for (int i = 0; i < tags.length - 1; ++i) {
            result[j++] = tags[i];
        }
        return result;
    }

    protected static String[] splitPath(String path) {
        String[] tags = AdornedToSketch.splitPathFull(path);
        String[] result = new String[tags.length - 2];
        int j = 0;
        for (int i = 2; i < tags.length; ++i) {
            result[j++] = tags[i];
        }
        return result;
    }

    protected static void processOneFile(String xmlFileName) {
        String outputXmlFileName = "";
        try {
            String shortInputXmlFileName = FileNameUtils.stripPathName(xmlFileName);
            BibadornedInfo bibadornedInfo = new BibadornedInfo(xmlFileName);
            boolean monkHeaderFound = bibadornedInfo.getMonkHeaderFound();
            TEIHeaderInfo teiadornedInfo = new TEIHeaderInfo(xmlFileName);
            outputFileStream.print("<work filename=\"");
            if (monkHeaderFound) {
                outputFileStream.print(bibadornedInfo.getFileName());
            } else {
                outputFileStream.print(teiadornedInfo.getFileName());
            }
            outputFileStream.print("\" title=\"");
            outputFileStream.print(teiadornedInfo.getTitle());
            outputFileStream.print("\" author=\"");
            List<TEIHeaderAuthor> authors = monkHeaderFound ? bibadornedInfo.getAuthors() : teiadornedInfo.getAuthors();
            boolean first = true;
            Set<String> prevAuthors = SetFactory.createNewSet();
            for (TEIHeaderAuthor author : authors) {
                String authorName = author.getName();
                if (!prevAuthors.contains(authorName)) {
                    if (!first) {
                        outputFileStream.print("|");
                    }
                    outputFileStream.print(authorName);
                    first = false;
                }
                prevAuthors.add(authorName);
            }
            outputFileStream.print("\"");
            if (monkHeaderFound) {
                outputFileStream.print(" circulationYear=\"");
                outputFileStream.print(bibadornedInfo.getCirculationYear());
                outputFileStream.print("\" genre=\"");
                outputFileStream.print(bibadornedInfo.getGenre());
                outputFileStream.print("\" subgenre=\"");
                outputFileStream.print(bibadornedInfo.getSubgenre());
                outputFileStream.print("\"");
            }
            outputFileStream.print(">");
            outputFileStream.println();
            AdornedXMLReader xmlReader = new AdornedXMLReader(xmlFileName);
            List<List<ExtendedAdornedWord>> sentences = xmlReader.getSentences();
            for (int i = 0; i < sentences.size(); ++i) {
                outputFileStream.println("<s>");
                List<ExtendedAdornedWord> sentence = sentences.get(i);
                for (int j = 0; j < sentence.size(); ++j) {
                    ExtendedAdornedWord word = sentence.get(j);
                    outputFileStream.print(word.getSpelling());
                    outputFileStream.print("\t");
                    outputFileStream.print(word.getPartsOfSpeech());
                    outputFileStream.print("\t");
                    outputFileStream.print(word.getLemmata());
                    outputFileStream.print("\t");
                    outputFileStream.print(word.getStandardSpelling());
                    outputFileStream.print("\t");
                    outputFileStream.println(word.getID());
                }
                outputFileStream.println("</s>");
            }
            outputFileStream.println("</work>");
            printStream.println("Processed " + xmlFileName);
        }
        catch (Exception e) {
            printStream.println("Problem converting " + xmlFileName + " to " + outputXmlFileName + ": " + e.getMessage());
        }
    }

    protected static int processFiles(String[] args) throws Exception {
        boolean result = false;
        String[] wildCards = new String[args.length - 2];
        for (int i = 2; i < args.length; ++i) {
            wildCards[i - 2] = args[i];
        }
        String[] fileNames = FileNameUtils.expandFileNameWildcards(wildCards);
        docsToProcess = fileNames.length;
        outputFileStream = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)), true, "utf-8");
        outputFileStream.println("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\" ?>");
        outputFileStream.print("<corpus name=\"");
        outputFileStream.print(corpusName);
        outputFileStream.println("\">");
        for (int i = 0; i < fileNames.length; ++i) {
            AdornedToSketch.processOneFile(fileNames[i]);
        }
        outputFileStream.println("</corpus>");
        outputFileStream.close();
        return fileNames.length;
    }

    protected static void terminate(int filesProcessed, long processingTime) {
        printStream.println("Processed " + Formatters.formatIntegerWithCommas(filesProcessed) + " files in " + Formatters.formatLongWithCommas(processingTime) + " seconds.");
    }
}

