/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools;

import edu.northwestern.at.utils.FileUtils;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.output.support.XMLOutputProcessor;
import org.jdom2.util.NamespaceStack;
import org.xml.sax.SAXException;

public class AdornedXMLWriter {
    public AdornedXMLWriter(Document document, String xmlOutputFileName) throws SAXException, IOException {
        this.outputXML(document, xmlOutputFileName);
    }

    protected void outputXML(Document document, String xmlOutputFileName) throws IOException {
        Format format = Format.getRawFormat();
        format.setIndent("  ");
        format.setEncoding("utf-8");
        format.setExpandEmptyElements(true);
        format.setTextMode(Format.TextMode.NORMALIZE);
        XMLOutputter xmlOut = new XMLOutputter(format, (XMLOutputProcessor)new AdornedXMLOutputProcessor(format));
        FileUtils.createPathForFile(xmlOutputFileName);
        FileOutputStream outputStream = new FileOutputStream(xmlOutputFileName, false);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedStream, "utf-8");
        xmlOut.output(document, (Writer)writer);
        try {
            writer.close();
            bufferedStream.close();
            outputStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public class AdornedXMLOutputProcessor
    extends AbstractXMLOutputProcessor {
        protected Format outputFormat;

        public AdornedXMLOutputProcessor(Format format) {
            this.outputFormat = format;
        }

        protected void printElement(Writer out, FormatStack fstack, NamespaceStack nstack, Element element) throws IOException {
            boolean isBlankElement = element.getName().equalsIgnoreCase("c");
            if (isBlankElement) {
                element.removeAttribute("part");
                fstack.push();
                fstack.setTextMode(Format.TextMode.PRESERVE);
            }
            super.printElement(out, fstack, nstack, element);
            if (isBlankElement) {
                fstack.pop();
            }
        }
    }
}

