/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.abbreviations.Abbreviations;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.RomanNumeralUtils;

public class TokenizerUtils {
    protected static Abbreviations abbreviations = new Abbreviations();

    public static String getTokenType(String token) {
        String result = "token";
        if (CharUtils.isPunctuation(token)) {
            result = "punctuation";
        } else if (CharUtils.isNumber(token)) {
            result = "number";
        } else if (CharUtils.isUSCurrency(token)) {
            result = "US currency";
        } else if (CharUtils.isUSCurrencyCents(token)) {
            result = "US currency";
        } else if (CharUtils.isCurrency(token)) {
            result = "currency";
        } else if (abbreviations.isAbbreviation(token)) {
            result = "abbreviation";
        } else if (CharUtils.isSymbol(token)) {
            result = "symbol";
        } else if (RomanNumeralUtils.isRomanNumeral(token) && !token.equals("I")) {
            result = "Roman numeral";
        }
        return result;
    }

    protected TokenizerUtils() {
    }
}

