/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.DefaultPreTokenizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.PreTokenizer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class PreTokenizerFactory {
    public static PreTokenizer newPreTokenizer() {
        String className = System.getProperty("pretokenizer.class");
        if (className == null) {
            className = "DefaultPreTokenizer";
        }
        return PreTokenizerFactory.newPreTokenizer(className);
    }

    public static PreTokenizer newPreTokenizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("pretokenizer.class");
        }
        if (className == null) {
            className = "DefaultPreTokenizer";
        }
        return PreTokenizerFactory.newPreTokenizer(className);
    }

    public static PreTokenizer newPreTokenizer(String className) {
        PreTokenizer preTokenizer = null;
        try {
            preTokenizer = (PreTokenizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(PreTokenizerFactory.class.getName()) + "." + className;
            try {
                preTokenizer = (PreTokenizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create pretokenizer of class " + fixedClassName + ", using default.");
                preTokenizer = new DefaultPreTokenizer();
            }
        }
        return preTokenizer;
    }
}

