/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.thesaurus;

import edu.northwestern.at.morphadorner.corpuslinguistics.thesaurus.AbstractThesaurus;
import edu.northwestern.at.morphadorner.corpuslinguistics.thesaurus.Thesaurus;
import edu.smu.tspell.wordnet.AdjectiveSynset;
import edu.smu.tspell.wordnet.AdverbSynset;
import edu.smu.tspell.wordnet.NounSynset;
import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.VerbSynset;
import edu.smu.tspell.wordnet.WordNetDatabase;
import edu.smu.tspell.wordnet.WordSense;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class WordnetThesaurus
extends AbstractThesaurus
implements Thesaurus {
    protected static final String DATABASE_DIRECTORY = "wordnet.database.dir";
    protected static String defaultDataDirectory = "data/wordnet/3.0/dict";
    protected WordNetDatabase wordnetData;

    public WordnetThesaurus() throws IOException, FileNotFoundException {
        if (this.getWordNetDataDirectory() == null) {
            this.setWordNetDataDirectory(defaultDataDirectory);
        }
        this.wordnetData = WordNetDatabase.getFileInstance();
    }

    public WordnetThesaurus(String dataDirectory) throws IOException, FileNotFoundException {
        this.setWordNetDataDirectory(dataDirectory);
        this.wordnetData = WordNetDatabase.getFileInstance();
    }

    protected void setWordNetDataDirectory(String wordNetDataDirectory) {
        System.setProperty(DATABASE_DIRECTORY, wordNetDataDirectory);
    }

    protected String getWordNetDataDirectory() {
        return System.getProperty(DATABASE_DIRECTORY);
    }

    @Override
    public List<String> getSynonyms(String word) {
        TreeSet<String> synonyms = new TreeSet<String>();
        Synset[] synsets = this.wordnetData.getSynsets(word);
        for (int i = 0; i < synsets.length; ++i) {
            Synset synset = synsets[i];
            String[] wordForms = synset.getWordForms();
            for (int j = 0; j < wordForms.length; ++j) {
                synonyms.add(wordForms[j]);
            }
        }
        return new ArrayList<String>(synonyms);
    }

    @Override
    public List<String> getSynonyms(String word, String wordClass) {
        TreeSet<String> synonyms = new TreeSet<String>();
        Synset[] synsets = this.wordnetData.getSynsets(word);
        SynsetType wordClassSynsetType = this.getWordClassSynsetType(wordClass);
        for (int i = 0; i < synsets.length; ++i) {
            Synset synset = synsets[i];
            if (wordClassSynsetType != null && wordClassSynsetType != synset.getType()) continue;
            String[] wordForms = synset.getWordForms();
            for (int j = 0; j < wordForms.length; ++j) {
                synonyms.add(wordForms[j]);
            }
        }
        return new ArrayList<String>(synonyms);
    }

    @Override
    public List<String> getAntonyms(String word) {
        return this.getAntonyms(word, null);
    }

    @Override
    public List<String> getAntonyms(String word, String wordClass) {
        TreeSet<String> antonyms = new TreeSet<String>();
        Synset[] synsets = this.wordnetData.getSynsets(word);
        SynsetType wordClassSynsetType = this.getWordClassSynsetType(wordClass);
        for (int i = 0; i < synsets.length; ++i) {
            Synset synset = synsets[i];
            SynsetType synsetType = synsets[i].getType();
            if (wordClassSynsetType != null && wordClassSynsetType != synsetType) continue;
            WordSense[] wordSenses = null;
            if (synsetType == SynsetType.ADJECTIVE) {
                wordSenses = ((AdjectiveSynset)synset).getAntonyms(word);
            } else if (synsetType == SynsetType.ADVERB) {
                wordSenses = ((AdverbSynset)synset).getAntonyms(word);
            } else if (synsetType == SynsetType.NOUN) {
                wordSenses = ((NounSynset)synset).getAntonyms(word);
            } else if (synsetType == SynsetType.VERB) {
                wordSenses = ((VerbSynset)synset).getAntonyms(word);
            }
            if (wordSenses == null) continue;
            for (int j = 0; j < wordSenses.length; ++j) {
                antonyms.add(wordSenses[j].getWordForm());
            }
        }
        return new ArrayList<String>(antonyms);
    }

    protected SynsetType getWordClassSynsetType(String wordClass) {
        SynsetType result = null;
        if (wordClass != null) {
            if (wordClass.equals("noun")) {
                result = SynsetType.NOUN;
            } else if (wordClass.equals("verb")) {
                result = SynsetType.VERB;
            } else if (wordClass.equals("adjective")) {
                result = SynsetType.ADJECTIVE;
            } else if (wordClass.equals("adverb")) {
                result = SynsetType.ADVERB;
            }
        }
        return result;
    }
}

