/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.thesaurus;

import edu.northwestern.at.morphadorner.corpuslinguistics.thesaurus.DefaultThesaurus;
import edu.northwestern.at.morphadorner.corpuslinguistics.thesaurus.Thesaurus;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class ThesaurusFactory {
    public static Thesaurus newThesaurus() {
        String className = System.getProperty("thesaurus.class");
        if (className == null) {
            className = "DefaultThesaurus";
        }
        return ThesaurusFactory.newThesaurus(className);
    }

    public static Thesaurus newThesaurus(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("thesaurus.class");
        }
        if (className == null) {
            className = "DefaultThesaurus";
        }
        return ThesaurusFactory.newThesaurus(className);
    }

    public static Thesaurus newThesaurus(String className) {
        Thesaurus thesaurus = null;
        try {
            thesaurus = (Thesaurus)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(ThesaurusFactory.class.getName()) + "." + className;
            try {
                thesaurus = (Thesaurus)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create thesaurus of class " + fixedClassName + ", using default.");
                try {
                    thesaurus = new DefaultThesaurus();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return thesaurus;
    }
}

