/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.textsummarizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.textsummarizer.DefaultTextSummarizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsummarizer.TextSummarizer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class TextSummarizerFactory {
    public static TextSummarizer newTextSummarizer() {
        String className = System.getProperty("summarizer.class");
        if (className == null) {
            className = "DefaultTextSummarizer";
        }
        return TextSummarizerFactory.newTextSummarizer(className);
    }

    public static TextSummarizer newTextSummarizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("summarizer.class");
        }
        if (className == null) {
            className = "DefaultTextSummarizer";
        }
        return TextSummarizerFactory.newTextSummarizer(className);
    }

    public static TextSummarizer newTextSummarizer(String className) {
        TextSummarizer summarizer = null;
        try {
            summarizer = (TextSummarizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(TextSummarizerFactory.class.getName()) + "." + className;
            try {
                summarizer = (TextSummarizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create summarizer of class " + fixedClassName + ", using default.");
                try {
                    summarizer = new DefaultTextSummarizer();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return summarizer;
    }
}

