/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.textsummarizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.stopwords.BuckleyAndSaltonStopWords;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsummarizer.AbstractTextSummarizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsummarizer.TextSummarizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.wordcounts.WordCountAndSentences;
import edu.northwestern.at.morphadorner.corpuslinguistics.wordcounts.WordCountUtils;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.SortedArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SimpleTextSummarizer
extends AbstractTextSummarizer
implements TextSummarizer {
    @Override
    public <T extends Comparable> List<Integer> summarize(List<List<T>> sentences, int summarySentences) {
        Map<String, WordCountAndSentences> wordCounts = WordCountUtils.countWordsInSentences(sentences, new BuckleyAndSaltonStopWords());
        SortedArrayList<WordCountAndSentences> wcsData = new SortedArrayList<WordCountAndSentences>();
        Iterator<String> iterator = wordCounts.keySet().iterator();
        while (iterator.hasNext()) {
            wcsData.add(wordCounts.get(iterator.next()));
        }
        TreeSet<Integer> summarySentencesSet = new TreeSet<Integer>();
        int maxWords = Math.min(100, wcsData.size());
        for (int i = 0; i < wcsData.size() && summarySentencesSet.size() < summarySentences; ++i) {
            WordCountAndSentences wcs = (WordCountAndSentences)wcsData.get(i);
            if (CharUtils.isNumber(wcs.word.toString()) || CharUtils.hasDigit(wcs.word.toString())) continue;
            Integer[] sentenceNumbers = wcs.sentences.toArray(new Integer[wcs.sentences.size()]);
            summarySentencesSet.add(sentenceNumbers[0]);
        }
        return new ArrayList<Integer>(summarySentencesSet);
    }
}

