/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter;

import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.AbstractTextSegmenter;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.TextSegmenter;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.struct.RawText;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.texttiling.TextTiling;
import edu.northwestern.at.utils.ListFactory;
import java.util.List;

public class TextTilingTextSegmenter
extends AbstractTextSegmenter
implements TextSegmenter {
    protected int slidingWindowSize = 10;
    protected int stepSize = 100;

    public int getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    public void setSlidingWindowSize(int slidingWindowSize) {
        this.slidingWindowSize = slidingWindowSize;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
    }

    @Override
    public <T> List<Integer> getSegmentPositions(List<List<T>> sentences) {
        RawText c = new RawText(sentences);
        TextTiling tiler = new TextTiling(c, this.stopWords);
        tiler.setWindowSize(this.slidingWindowSize);
        tiler.setStepSize(this.stepSize);
        tiler.similarityDetermination();
        tiler.depthScore();
        tiler.boundaryIdentification();
        List<Integer> sentenceBoundaries = c.boundaries;
        List<Integer> result = ListFactory.createNewList();
        List<Integer> segmentation = tiler.getSegmentation();
        result.add(0);
        for (int i = 1; i < sentenceBoundaries.size(); ++i) {
            int start = sentenceBoundaries.get(i - 1);
            int end = sentenceBoundaries.get(i);
            if (!segmentation.contains(start)) continue;
            result.add(i - 1);
        }
        return result;
    }
}

