/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.stringsimilarity;

import edu.northwestern.at.morphadorner.corpuslinguistics.stringsimilarity.StringSimilarity;

public class LevensteinDistance
implements StringSimilarity {
    public static int editDistance(String s1, String s2) {
        String ts1 = s1;
        String ts2 = s2;
        if (ts1 == null) {
            ts1 = "";
        }
        if (ts2 == null) {
            ts2 = "";
        }
        int ls1 = ts1.length();
        int ls2 = ts2.length();
        if (ls1 == 0) {
            return ls2;
        }
        if (ls2 == 0) {
            return ls1;
        }
        int[][] d = new int[3][ls1 + 1];
        for (int i = 0; i <= ls1; ++i) {
            d[0][i] = 0;
            d[1][i] = i;
        }
        for (int j = 1; j <= ls2; ++j) {
            char cs2 = ts2.charAt(j - 1);
            d[2][0] = j;
            for (int i = 1; i <= ls1; ++i) {
                char cs1 = ts1.charAt(i - 1);
                int cost = cs1 == cs2 ? 0 : 1;
                int dt = Math.min(d[2][i - 1] + 1, Math.min(d[1][i] + 1, d[1][i - 1] + cost));
                if (i > 2 && j > 2) {
                    int trans = d[0][i - 2] + 1;
                    if (ts1.charAt(i - 2) != cs2) {
                        ++trans;
                    }
                    if (cs1 != ts2.charAt(j - 2)) {
                        ++trans;
                    }
                    if (dt > trans) {
                        dt = trans;
                    }
                }
                d[2][i] = dt;
            }
            for (int k = 0; k <= ls1; ++k) {
                d[0][k] = d[1][k];
                d[1][k] = d[2][k];
            }
        }
        return d[2][ls1];
    }

    public static double levensteinSimilarity(String s1, String s2) {
        String ts1 = s1;
        String ts2 = s2;
        if (ts1 == null) {
            ts1 = "";
        }
        if (ts2 == null) {
            ts2 = "";
        }
        int ls1 = ts1.length();
        int ls2 = ts2.length();
        double dist = LevensteinDistance.editDistance(s1, s2);
        double maxLength = Math.max(ls1, ls2);
        double result = 1.0;
        if (maxLength > 0.0) {
            result = 1.0 - dist / maxLength;
        }
        return result;
    }

    public static boolean areAlike(String s1, String s2) {
        String ts1 = s1;
        String ts2 = s2;
        if (ts1 == null) {
            ts1 = "";
        }
        if (ts2 == null) {
            ts2 = "";
        }
        int ls1 = ts1.length();
        int ls2 = ts2.length();
        if (ls2 > ls1 && ts2.toLowerCase().startsWith(ts1.toLowerCase())) {
            return true;
        }
        int threshold = Math.max(3, (int)Math.floor(1.0 + (double)(ls1 + 2) / 4.0));
        if (Math.abs(ls2 - ls1) > threshold) {
            return false;
        }
        return LevensteinDistance.editDistance(ts1, ts2) <= threshold;
    }

    @Override
    public double similarity(String s1, String s2) {
        return LevensteinDistance.levensteinSimilarity(s1, s2);
    }
}

