/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.stopwords;

import edu.northwestern.at.morphadorner.corpuslinguistics.stopwords.DefaultStopWords;
import edu.northwestern.at.morphadorner.corpuslinguistics.stopwords.StopWords;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class StopWordsFactory {
    public static StopWords newStopWords() {
        String className = System.getProperty("stopwords.class");
        if (className == null) {
            className = "DefaultStopWords";
        }
        return StopWordsFactory.newStopWords(className);
    }

    public static StopWords newStopWords(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("stopwords.class");
        }
        if (className == null) {
            className = "DefaultStopWords";
        }
        return StopWordsFactory.newStopWords(className);
    }

    public static StopWords newStopWords(String className) {
        StopWords stopwords = null;
        try {
            stopwords = (StopWords)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(StopWordsFactory.class.getName()) + "." + className;
            try {
                stopwords = (StopWords)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create stopwords of class " + fixedClassName + ", using default.");
                try {
                    stopwords = new DefaultStopWords();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return stopwords;
    }
}

