/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.statistics;

import edu.northwestern.at.utils.math.ArithUtils;
import edu.northwestern.at.utils.math.distributions.Sig;

public class Frequency {
    public static double[] logLikelihoodFrequencyComparison(int sampleCount, int refCount, int sampleSize, int refSize, boolean computeLLSig) {
        double[] result = new double[6];
        double a = sampleCount;
        double b = refCount;
        double c = sampleSize;
        double d = refSize;
        double e1 = c * (a + b) / (c + d);
        double e2 = d * (a + b) / (c + d);
        double ae1 = 0.0;
        if (e1 != 0.0) {
            ae1 = a / e1;
        }
        double be2 = 0.0;
        if (e2 != 0.0) {
            be2 = b / e2;
        }
        double logLike = 2.0 * (a * ArithUtils.safeLog(ae1) + b * ArithUtils.safeLog(be2));
        result[0] = a;
        result[1] = c == 0.0 ? 0.0 : 100.0 * (a / c);
        result[2] = b;
        result[3] = d == 0.0 ? 0.0 : 100.0 * (b / d);
        result[4] = logLike;
        result[5] = 0.0;
        if (computeLLSig) {
            result[5] = Sig.chisquare(logLike, 1);
        }
        return result;
    }

    public static double[] logLikelihoodFrequencyComparison(int sampleCount, int refCount, int sampleSize, int refSize) {
        return Frequency.logLikelihoodFrequencyComparison(sampleCount, refCount, sampleSize, refSize, true);
    }

    protected Frequency() {
    }
}

