/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.DefaultSpellingStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.SpellingStandardizer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class SpellingStandardizerFactory {
    public static SpellingStandardizer newSpellingStandardizer() {
        String className = System.getProperty("spellingstandardizer.class");
        if (className == null) {
            className = "DefaultSpellingStandardizer";
        }
        return SpellingStandardizerFactory.newSpellingStandardizer(className);
    }

    public static SpellingStandardizer newSpellingStandardizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("spellingstandardizer.class");
        }
        if (className == null) {
            className = "DefaultSpellingStandardizer";
        }
        return SpellingStandardizerFactory.newSpellingStandardizer(className);
    }

    public static SpellingStandardizer newInitialSpellingStandardizer() {
        String className = System.getProperty("initialspellingstandardizer.class");
        if (className == null) {
            className = "NoopSpellingStandardizer";
        }
        return SpellingStandardizerFactory.newSpellingStandardizer(className);
    }

    public static SpellingStandardizer newInitialSpellingStandardizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("initialspellingstandardizer.class");
        }
        if (className == null) {
            className = "NoopSpellingStandardizer";
        }
        return SpellingStandardizerFactory.newSpellingStandardizer(className);
    }

    public static SpellingStandardizer newSpellingStandardizer(String className) {
        SpellingStandardizer spellingStandardizer = null;
        try {
            spellingStandardizer = (SpellingStandardizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(SpellingStandardizerFactory.class.getName()) + "." + className;
            try {
                spellingStandardizer = (SpellingStandardizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create spelling standardizer of class " + fixedClassName + ", using default.");
                spellingStandardizer = new DefaultSpellingStandardizer();
            }
        }
        return spellingStandardizer;
    }
}

