/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.TernaryTrie;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GapFiller {
    protected TernaryTrie trie;

    public GapFiller(Map<String, String> wordsMap) {
        try {
            this.trie = new TernaryTrie(wordsMap, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GapFiller(Set<String> wordsSet) {
        try {
            this.trie = new TernaryTrie(wordsSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GapFiller(List<String> wordsList) {
        try {
            this.trie = new TernaryTrie(wordsList);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GapFiller(TaggedStrings wordsList) {
        try {
            this.trie = new TernaryTrie(wordsList, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GapFiller(TernaryTrie trie) {
        this.trie = trie;
    }

    protected void addWordPrivate(String word) {
        this.trie.put(word, word);
    }

    public void addWord(String word) {
        this.addWordPrivate(word);
    }

    public void addWords(String[] words) {
        for (int i = 0; i < words.length; ++i) {
            this.addWord(words[i]);
        }
    }

    public void addWords(Collection<String> words) {
        Iterator<String> iterator = words.iterator();
        while (iterator.hasNext()) {
            this.addWord(iterator.next());
        }
    }

    public List<String> getMatchingWords(String word, char gapChar) {
        List<String> result = ListFactory.createNewList();
        if (this.trie != null) {
            String dotWord = word.replaceAll(gapChar + "", ".");
            result.addAll(this.trie.partialSearch(dotWord));
            Iterator<String> iterator = result.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().indexOf("~") < 0) continue;
                iterator.remove();
            }
        }
        return result;
    }

    public List<String> getMatchingWords(String word) {
        return this.getMatchingWords(word, '\u25cf');
    }
}

