/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.AbstractSpellingStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.EnglishDecruftifier;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.SpellingStandardizer;
import edu.northwestern.at.utils.MapFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;

public class DecruftifyingSpellingStandardizer
extends AbstractSpellingStandardizer
implements SpellingStandardizer {
    protected Map<String, String> cache = MapFactory.createNewMap(20000);

    @Override
    public void loadAlternativeSpellings(Reader reader, String delimChars) throws IOException {
    }

    @Override
    public String[] standardizeSpelling(String spelling) {
        String result = this.cache.get(spelling);
        if (result == null) {
            result = EnglishDecruftifier.decruftify(spelling);
            this.cache.put(spelling, result);
        }
        return new String[]{this.fixCapitalization(spelling, result)};
    }

    @Override
    public String standardizeSpelling(String spelling, String wordClass) {
        return this.standardizeSpelling(spelling)[0];
    }

    public String toString() {
        return "Decruftifying Spelling Standardizer";
    }
}

