/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper;

import edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper.DefaultSpellingMapper;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper.SpellingMapper;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class SpellingMapperFactory {
    public static SpellingMapper newSpellingMapper() {
        String className = System.getProperty("spellingmapper.class");
        if (className == null) {
            className = "DefaultSpellingMapper";
        }
        return SpellingMapperFactory.newSpellingMapper(className);
    }

    public static SpellingMapper newSpellingMapper(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("spellingmapper.class");
        }
        if (className == null) {
            className = "DefaultSpellingMapper";
        }
        return SpellingMapperFactory.newSpellingMapper(className);
    }

    public static SpellingMapper newSpellingMapper(String className) {
        SpellingMapper spellingMapper = null;
        try {
            spellingMapper = (SpellingMapper)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(SpellingMapperFactory.class.getName()) + "." + className;
            try {
                spellingMapper = (SpellingMapper)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create spelling mapper of class " + fixedClassName + ", using default.");
                spellingMapper = new DefaultSpellingMapper();
            }
        }
        return spellingMapper;
    }
}

