/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper;

import edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper.SpellingMapper;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;

public class BritishToUSSpellingMapper
implements SpellingMapper {
    protected static final String wordMapPath = "resources/abbc.tab";
    protected static Map<String, String> britToUSMap = null;

    public BritishToUSSpellingMapper() {
        if (britToUSMap == null) {
            try {
                britToUSMap = MapFactory.createNewMap();
                this.loadBritishToUSWordMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void loadBritishToUSWordMap() throws MalformedURLException, IOException {
        URL wordMapURL = BritishToUSSpellingMapper.class.getResource(wordMapPath);
        BufferedReader mapReader = new BufferedReader(new UnicodeReader(wordMapURL.openStream()));
        String line = mapReader.readLine();
        while (line != null) {
            StringTokenizer tokens = new StringTokenizer(line, "\t");
            String usWord = tokens.nextToken().trim();
            String britWord = tokens.nextToken().trim();
            britToUSMap.put(britWord, usWord);
            line = mapReader.readLine();
        }
        mapReader.close();
    }

    @Override
    public String mapSpelling(String spelling) {
        String result = spelling;
        String usSpelling = britToUSMap.get(spelling.toLowerCase());
        if (usSpelling != null) {
            result = CharUtils.makeCaseMatch(usSpelling, spelling);
        }
        return result;
    }
}

