/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter;

import com.ibm.icu.text.BreakIterator;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.SentenceSplitterIterator;
import java.util.Locale;

public class ICU4JBreakIteratorSentenceSplitterIterator
implements SentenceSplitterIterator {
    protected BreakIterator sentenceExtractor;
    protected int start = -1;
    protected int end = -1;
    protected String text;

    public ICU4JBreakIteratorSentenceSplitterIterator() {
        this.sentenceExtractor = BreakIterator.getSentenceInstance((Locale)Locale.US);
    }

    public ICU4JBreakIteratorSentenceSplitterIterator(Locale locale) {
        this.sentenceExtractor = BreakIterator.getSentenceInstance((Locale)locale);
    }

    public ICU4JBreakIteratorSentenceSplitterIterator(String text) {
        this.sentenceExtractor = BreakIterator.getSentenceInstance((Locale)Locale.US);
        this.setText(text);
    }

    public ICU4JBreakIteratorSentenceSplitterIterator(String text, Locale locale) {
        this.sentenceExtractor = BreakIterator.getSentenceInstance((Locale)locale);
        this.setText(text);
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.sentenceExtractor.setText(this.text);
        this.start = this.sentenceExtractor.first();
        this.end = this.sentenceExtractor.next();
    }

    @Override
    public boolean hasNext() {
        return this.end != -1;
    }

    @Override
    public String next() {
        String result = null;
        if (this.end != -1) {
            result = this.text.substring(this.start, this.end);
            this.start = this.end;
            this.end = this.sentenceExtractor.next();
        }
        return result;
    }

    @Override
    public String peek() {
        String result = null;
        if (this.end != -1) {
            result = this.text.substring(this.start, this.end);
        }
        return result;
    }
}

