/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.suffix;

import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.CanTagOneWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.unigram.UnigramTagger;
import edu.northwestern.at.utils.CharUtils;

public class SuffixTagger
extends UnigramTagger
implements PartOfSpeechTagger,
CanTagOneWord {
    @Override
    public String tagWord(String word) {
        String result = "";
        if (CharUtils.isPunctuationOrSymbol(word)) {
            result = word;
        } else {
            int l = word.length();
            for (int i = Math.min(10, l); i > 0; --i) {
                String suffix = word.substring(l - i, l);
                if (this.lexicon.getEntryCount(suffix) <= 0) continue;
                result = this.lexicon.getLargestCategory(word);
                break;
            }
            if (result.length() == 0) {
                result = this.lexicon.getPartOfSpeechTags().getSingularNounTag();
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return "Suffix tagger";
    }
}

