/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.lexical;

import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.lexical.AbstractLexicalSmoother;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.lexical.LexicalSmoother;
import edu.northwestern.at.utils.math.Probability;
import java.util.List;

public class AdditiveLexicalSmoother
extends AbstractLexicalSmoother
implements LexicalSmoother {
    protected boolean debug = true;
    protected double additiveAdjustmentValue = 0.5;

    @Override
    public Probability lexicalProbability(String word, String tag) {
        Probability result = null;
        if (this.cachedLexicalProbabilities != null) {
            result = (Probability)this.cachedLexicalProbabilities.get(word, tag);
        }
        if (result == null) {
            Lexicon lexicon = this.partOfSpeechTagger.getLexicon(word);
            int tagCount = Math.max(lexicon.getCategoryCount(tag), 1);
            int catCount = this.partOfSpeechTagger.getTagCount(word, tag);
            List<String> tags = this.partOfSpeechTagger.getTagsForWord(word);
            double prob = ((double)catCount + this.additiveAdjustmentValue) / ((double)tagCount + this.additiveAdjustmentValue * (double)tags.size());
            try {
                result = new Probability(prob);
            }
            catch (Exception e) {
                if (this.debug) {
                    this.logger.logError("word=" + word + ", tag=" + tag + ", catCount=" + catCount + ", adj=" + this.additiveAdjustmentValue + ", tagCount=" + tagCount + ", tags.size=" + tags.size() + ", prob=" + prob);
                }
                result = new Probability(1.0);
            }
            if (this.cachedLexicalProbabilities != null) {
                this.cachedLexicalProbabilities.put(word, tag, result);
            }
        }
        return result;
    }
}

