/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.simplerulebased;

import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.PartOfSpeechRetagger;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.unigram.UnigramTagger;
import java.util.List;

public class SimpleRuleBasedTagger
extends UnigramTagger
implements PartOfSpeechTagger,
PartOfSpeechRetagger {
    @Override
    public List<AdornedWord> tagSentence(List<String> sentence) {
        List<AdornedWord> taggedSentence = super.tagSentence(sentence);
        return this.retagWords(taggedSentence);
    }

    @Override
    public <T extends AdornedWord> List<T> retagWords(List<T> taggedSentence) {
        PartOfSpeechTags posTags = this.lexicon.getPartOfSpeechTags();
        AdornedWord previousWord = null;
        for (int i = 0; i < taggedSentence.size(); ++i) {
            AdornedWord word = (AdornedWord)taggedSentence.get(i);
            String spelling = word.getSpelling();
            String posTag = word.getPartsOfSpeech();
            if (previousWord != null && posTags.isDeterminerTag(previousWord.getPartsOfSpeech()) && posTags.isVerbTag(posTag)) {
                word.setPartsOfSpeech(posTags.getSingularNounTag());
            }
            if (posTags.isNounTag(posTag) && !posTags.isProperNounTag(posTag) && spelling.endsWith("ed")) {
                word.setPartsOfSpeech(posTags.getPastParticipleTag());
            }
            if (spelling.endsWith("ly")) {
                word.setPartsOfSpeech(posTags.getAdverbTag());
            }
            if (posTags.isNounTag(posTag) && !posTags.isProperNounTag(posTag) && spelling.endsWith("al")) {
                word.setPartsOfSpeech(posTags.getAdjectiveTag());
            }
            if (previousWord != null && posTags.isNounTag(posTag) && !posTags.isProperNounTag(posTag) && previousWord.getSpelling().equalsIgnoreCase("would")) {
                word.setPartsOfSpeech(posTags.getVerbTag());
            }
            if (posTag.equals(posTags.getSingularNounTag()) && spelling.endsWith("s")) {
                word.setPartsOfSpeech(posTags.getPluralNounTag());
            }
            if (spelling.endsWith("ing") && posTags.isNounTag(posTag) && !posTags.isProperNounTag(posTag)) {
                word.setPartsOfSpeech(posTags.getPresentParticipleTag());
            }
            previousWord = word;
            taggedSentence.remove(i);
            taggedSentence.add(i, word);
        }
        return taggedSentence;
    }

    @Override
    public <T extends AdornedWord> List<T> retagSentence(List<T> sentence) {
        return this.retagWords(sentence);
    }

    @Override
    public boolean getCanAddOrDeleteWords() {
        return false;
    }

    @Override
    public void setCanAddOrDeleteWords(boolean canAddOrDeleteWords) {
    }

    @Override
    public String toString() {
        return "Simple rule based tagger";
    }
}

