/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.Map2D;
import edu.northwestern.at.utils.Map2DFactory;
import edu.northwestern.at.utils.Map3D;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.math.Probability;
import java.util.List;

public class Viterbi {
    protected Map2D<Integer, String, Probability> trellis;
    protected Map2D<Integer, String, String> tracebackTags;
    protected double beamWidth = Math.log(1000.0);
    protected int beamSearchRejections = 0;
    protected Logger logger;

    public Viterbi() {
        this.reset();
    }

    public void reset() {
        String startState = ".";
        this.trellis = Map2DFactory.createNewMap2D();
        this.tracebackTags = Map2DFactory.createNewMap2D();
        this.trellis.put(new Integer(-2), startState, Probability.ONE_PROBABILITY);
        this.trellis.put(new Integer(-1), startState, Probability.ONE_PROBABILITY);
        this.beamSearchRejections = 0;
        this.logger = new DummyLogger();
    }

    public Probability getScore(int index, String tag) {
        Probability result = Probability.ZERO_PROBABILITY;
        Probability score = this.trellis.get(new Integer(index), tag);
        if (score != null) {
            result = score;
        }
        return result;
    }

    public String getTracebackTag(int index, String tag) {
        String result = this.tracebackTags.get(new Integer(index), tag);
        if (result == null) {
            result = "*";
        }
        return result;
    }

    public void setScore(int index, String tag, String tracebackTag, Probability score) {
        this.trellis.put(new Integer(index), tag, score);
        this.tracebackTags.put(new Integer(index), tag, tracebackTag);
    }

    public List<String> updateScore(int wordIndex, Probability[] lexicalProbs, Map2D contextualProbs, List<String> tags, List<String> prevTags) {
        Probability bestScore = Probability.ZERO_PROBABILITY;
        for (int i = 0; i < tags.size(); ++i) {
            String tag = tags.get(i);
            Probability lexicalProb = lexicalProbs[i];
            for (int j = 0; j < prevTags.size(); ++j) {
                Probability contextualProb;
                String prevTag = prevTags.get(j);
                Probability scorem1 = this.getScore(wordIndex - 1, prevTag);
                Probability score = scorem1.multiply(lexicalProb, contextualProb = (Probability)contextualProbs.get(tag, prevTag));
                if (score.compareTo(this.getScore(wordIndex, tag)) <= 0) continue;
                bestScore = score;
                this.setScore(wordIndex, tag, prevTag, score);
            }
        }
        return this.pruneTags(wordIndex, tags, bestScore);
    }

    public List<String> updateScore(int wordIndex, Probability[] lexicalProbs, Map3D contextualProbs, List<String> tags, List<String> prevTags, List<String> prevPrevTags) {
        Probability bestScore = Probability.ZERO_PROBABILITY;
        for (int i = 0; i < tags.size(); ++i) {
            String tag = tags.get(i);
            Probability lexicalProb = lexicalProbs[i];
            Probability currentScore = this.getScore(wordIndex, tag);
            for (int j = 0; j < prevTags.size(); ++j) {
                String prevTag = prevTags.get(j);
                Probability scorem1 = this.getScore(wordIndex - 1, prevTag).multiply(lexicalProb);
                for (int k = 0; k < prevPrevTags.size(); ++k) {
                    Probability contextualProb = (Probability)contextualProbs.get(tag, prevTag, prevPrevTags.get(k));
                    Probability score = scorem1.multiply(contextualProb);
                    if (score.compareTo(currentScore) <= 0) continue;
                    bestScore = score;
                    currentScore = score;
                    this.setScore(wordIndex, tag, prevTag, currentScore);
                }
            }
        }
        return this.pruneTags(wordIndex, tags, bestScore);
    }

    protected List<String> pruneTags(int wordIndex, List<String> tags, Probability bestScore) {
        List<String> passedTags = ListFactory.createNewList();
        double dBestScore = bestScore.getLogProbability();
        for (int i = 0; i < tags.size(); ++i) {
            String tag = tags.get(i);
            Probability tagScore = this.getScore(wordIndex, tag);
            double dTagScore = tagScore.getLogProbability();
            if (dBestScore - dTagScore > this.beamWidth) {
                this.trellis.remove(new Integer(wordIndex), tag);
                ++this.beamSearchRejections;
                continue;
            }
            passedTags.add(tag);
        }
        return passedTags;
    }

    public List<String> optimalTags(int nWords, List<String> tags) {
        List<String> tagList = ListFactory.createNewList();
        int wordIndex = nWords - 1;
        String bestTag = ".";
        Probability bestScore = Probability.ZERO_PROBABILITY;
        for (int i = 0; i < tags.size(); ++i) {
            String tag = tags.get(i);
            if (this.getScore(wordIndex, tag).compareTo(bestScore) <= 0) continue;
            bestScore = this.getScore(wordIndex, tag);
            bestTag = tag;
        }
        while (wordIndex >= 0) {
            tagList.add(0, bestTag);
            bestTag = this.getTracebackTag(wordIndex--, bestTag);
        }
        return tagList;
    }

    public int getBeamSearchRejections() {
        return this.beamSearchRejections;
    }

    public double beamWidth() {
        return this.beamWidth;
    }

    public void beamWidth(double beamWidth) {
        this.beamWidth = beamWidth;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

