/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.phonetics;

public class DoubleMetaphone {
    private int current;
    private int encodeLimit = 4;
    private StringBuffer primary = new StringBuffer();
    private StringBuffer alternate = new StringBuffer();
    private String input;
    private static final char[] vowels = new char[]{'A', 'E', 'I', 'O', 'U', 'Y'};
    private static final char[] AEOU = new char[]{'A', 'E', 'O', 'U'};
    private static final char[] AO = "AO".toCharArray();
    private static final char[] BDH = new char[]{'B', 'D', 'H'};
    private static final char[] BFHLMNRVW_ = "BFHLMNRVW ".toCharArray();
    private static final char[] BH = new char[]{'B', 'H'};
    private static final char[] BKLMNSTZ = "LTKSNMBZ".toCharArray();
    private static final char[] BP = "BP".toCharArray();
    private static final char[] CGQ = new char[]{'C', 'G', 'Q'};
    private static final char[] CGLRT = new char[]{'C', 'G', 'L', 'R', 'T'};
    private static final char[] CKQ = new char[]{'C', 'K', 'Q'};
    private static final char[] CX = "CX".toCharArray();
    private static final char[] DT = "DT".toCharArray();
    private static final char[] EI = new char[]{'E', 'I'};
    private static final char[] EIY = new char[]{'E', 'I', 'Y'};
    private static final char[] EHI = new char[]{'I', 'E', 'H'};
    private static final char[] KLS = "KLS".toCharArray();
    private static final char[] LMNW = "LMNW".toCharArray();
    private static final char[] ST = new char[]{'S', 'T'};
    private static final char[] SZ = "SZ".toCharArray();
    private static final String[] AggiOggi = new String[]{"AGGI", "OGGI"};
    private static final String[] AiOi = new String[]{"AI", "OI"};
    private static final String[] AlleIllaIllo = new String[]{"ILLO", "ILLA", "ALLE"};
    private static final String[] AmOm = new String[]{"OM", "AM"};
    private static final String[] AsOs = new String[]{"AS", "OS"};
    private static final String[] ArchitOrchesOrchid = new String[]{"ARCHIT", "ORCHES", "ORCHID"};
    private static final String[] AuOu = new String[]{"AU", "OU"};
    private static final String[] BacherMacher = new String[]{"BACHER", "MACHER"};
    private static final String[] CeCiCy = new String[]{"CI", "CE", "CY"};
    private static final String[] CeCi = new String[]{"CE", "CI"};
    private static final String[] CiaCieCio = new String[]{"CIO", "CIE", "CIA"};
    private static final String[] CkCgCq = new String[]{"CK", "CG", "CQ"};
    private static final String[] DangerMangerRanger = new String[]{"DANGER", "RANGER", "MANGER"};
    private static final String[] DdDt = new String[]{"DD", "DT"};
    private static final String[] EauIau = new String[]{"IAU", "EAU"};
    private static final String[] EbEiElEpErEsEyIbIlInIe = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
    private static final String[] EdEmEnErOoUy = new String[]{"OO", "ER", "EN", "UY", "ED", "EM"};
    private static final String[] EnEr = new String[]{"ER", "EN"};
    private static final String[] EwskiEwskyOwskiOwsky = new String[]{"EWSKI", "EWSKY", "OWSKI", "OWSKY"};
    private static final String[] GnKnPnPsWr = new String[]{"GN", "KN", "PN", "WR", "PS"};
    private static final String[] HaracHaris = new String[]{"HARAC", "HARIS"};
    private static final String[] HeimHoekHolmHolz = new String[]{"HEIM", "HOEK", "HOLM", "HOLZ"};
    private static final String[] HemHiaHorHym = new String[]{"HOR", "HYM", "HIA", "HEM"};
    private static final String[] IslYsl = new String[]{"ISL", "YSL"};
    private static final String[] MaMe = new String[]{"ME", "MA"};
    private static final String[] OgyRgy = new String[]{"RGY", "OGY"};
    private static final String[] SiaSio = new String[]{"SIO", "SIA"};
    private static final String[] TiaTch = new String[]{"TIA", "TCH"};
    private static final String[] UcceeUcces = new String[]{"UCCEE", "UCCES"};
    private static final String[] Van_Von_ = new String[]{"VAN ", "VON "};
    private static final String[] WiczWitz = new String[]{"WICZ", "WITZ"};
    private static final String[] ZaZiZo = new String[]{"ZO", "ZI", "ZA"};

    public String getPrimary() {
        return this.primary.toString();
    }

    public StringBuffer getPrimaryBuffer() {
        return this.primary;
    }

    public String getAlternate() {
        return this.alternate.toString();
    }

    public StringBuffer getAlternateBuffer() {
        return this.alternate;
    }

    public int getEncodeLimit() {
        return this.encodeLimit;
    }

    public boolean setEncodeLimit(int newLimit) {
        if (newLimit < 1) {
            return false;
        }
        this.encodeLimit = newLimit;
        return true;
    }

    void setInput(String in) {
        this.input = in != null ? in.toUpperCase() + "     " : "";
    }

    void add(char ch) {
        this.add(ch, ch);
    }

    void add(char primaryChar, char alternateChar) {
        this.primary.append(primaryChar);
        this.alternate.append(alternateChar);
    }

    boolean charAt(int index, char[] list) {
        if (index < 0 || index >= this.input.length()) {
            return false;
        }
        char value = this.input.charAt(index);
        for (int i = 0; i < list.length; ++i) {
            if (value != list[i]) continue;
            return true;
        }
        return false;
    }

    boolean stringAt(int start, int length, String str) {
        String[] list = new String[]{str};
        return this.stringAt(start, length, list);
    }

    boolean stringAt(int start, int length, String[] list) {
        if (length <= 0) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!this.input.regionMatches(start, list[i], 0, length)) continue;
            return true;
        }
        return false;
    }

    boolean isVowel(int index) {
        return this.charAt(index, vowels);
    }

    boolean isSlavoGermanic() {
        return this.input.indexOf(87) > -1 || this.input.indexOf(75) > -1 || this.input.indexOf("CZ") > -1 || this.input.indexOf("WITZ") > -1;
    }

    void addCode(char ch, char code) {
        this.add(code);
        ++this.current;
        if (this.input.charAt(this.current) == ch) {
            ++this.current;
        }
    }

    public static String sencode(String in) {
        DoubleMetaphone dm = new DoubleMetaphone();
        return dm.encode(in);
    }

    public String encode(String in) {
        if (in == null) {
            return "";
        }
        this.primary.delete(0, this.primary.length());
        this.alternate.delete(0, this.alternate.length());
        int length = in.length();
        if (length < 1) {
            return "";
        }
        int last = length - 1;
        this.setInput(in);
        this.current = 0;
        if (this.stringAt(0, 2, GnKnPnPsWr)) {
            ++this.current;
        }
        if (this.input.startsWith("X")) {
            this.add('S');
            ++this.current;
        }
        block26: while ((this.primary.length() < this.encodeLimit || this.alternate.length() < this.encodeLimit) && this.current < length) {
            switch (this.input.charAt(this.current)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    if (this.current == 0) {
                        this.add('A');
                    }
                    ++this.current;
                    continue block26;
                }
                case 'B': {
                    this.addCode('B', 'P');
                    continue block26;
                }
                case '\u00c7': {
                    this.add('S');
                    ++this.current;
                    continue block26;
                }
                case 'C': {
                    if (this.current > 1 && !this.isVowel(this.current - 2) && this.input.regionMatches(this.current - 1, "ACH", 0, 3) && (this.input.charAt(this.current + 2) != 'I' && this.input.charAt(this.current + 2) != 'E' || this.stringAt(this.current - 2, 6, BacherMacher))) {
                        this.add('K');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.current == 0 && this.input.regionMatches(this.current, "CAESAR", 0, 6)) {
                        this.add('S');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.input.regionMatches(this.current, "CHIA", 0, 4)) {
                        this.add('K');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.input.regionMatches(this.current, "CH", 0, 2)) {
                        if (this.current > 0 && this.input.regionMatches(this.current, "CHAE", 0, 4)) {
                            this.add('K', 'X');
                            this.current += 2;
                            continue block26;
                        }
                        if (this.current == 0 && (this.stringAt(this.current + 1, 5, HaracHaris) || this.stringAt(this.current + 1, 3, HemHiaHorHym)) && !this.input.regionMatches(0, "CHORE", 0, 5)) {
                            this.add('K');
                            this.current += 2;
                            continue block26;
                        }
                        if (this.stringAt(0, 4, Van_Von_) || this.input.regionMatches(0, "SCH ", 0, 3) || this.stringAt(0, 6, ArchitOrchesOrchid) || this.charAt(this.current + 2, ST) || (this.charAt(this.current - 1, AEOU) || this.current == 0) && this.charAt(this.current + 2, BFHLMNRVW_)) {
                            this.add('K');
                        } else if (this.current > 0) {
                            if (this.input.regionMatches(0, "MC", 0, 2)) {
                                this.add('K');
                            } else {
                                this.add('X', 'K');
                            }
                        } else {
                            this.add('X');
                        }
                        this.current += 2;
                        continue block26;
                    }
                    if (this.input.regionMatches(this.current, "CZ", 0, 2) && !this.input.regionMatches(this.current - 2, "WICZ", 0, 4)) {
                        this.add('S', 'X');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.input.regionMatches(this.current + 1, "CIA", 0, 3)) {
                        this.add('X');
                        this.current += 3;
                        continue block26;
                    }
                    if (this.input.regionMatches(this.current, "CC", 0, 2) && (this.current != 1 || this.input.charAt(0) != 'M')) {
                        if (this.charAt(this.current + 2, EHI) && !this.input.regionMatches(this.current + 2, "HU", 0, 2)) {
                            if (this.current == 1 && this.input.charAt(this.current - 1) == 'A' || this.stringAt(this.current - 1, 5, UcceeUcces)) {
                                this.add('K');
                                this.add('S');
                            } else {
                                this.add('X');
                            }
                            this.current += 3;
                            continue block26;
                        }
                        this.add('K');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.stringAt(0, 2, CkCgCq)) {
                        this.add('K');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.stringAt(0, 2, CeCiCy)) {
                        if (this.stringAt(0, 3, CiaCieCio)) {
                            this.add('S', 'X');
                        } else {
                            this.add('S');
                        }
                        this.current += 2;
                        continue block26;
                    }
                    this.add('K');
                    if (this.charAt(this.current + 1, CGQ)) {
                        this.current += 3;
                        continue block26;
                    }
                    if (this.charAt(this.current + 1, CKQ) && !this.stringAt(this.current + 1, 2, CeCi)) {
                        this.current += 2;
                        continue block26;
                    }
                    ++this.current;
                    continue block26;
                }
                case 'D': {
                    if (this.input.regionMatches(this.current, "DG", 0, 2)) {
                        if (this.charAt(this.current + 2, EIY)) {
                            this.add('J');
                            this.current += 3;
                            continue block26;
                        }
                        this.add('T');
                        this.add('K');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.stringAt(this.current, 2, DdDt)) {
                        this.add('T');
                        this.current += 2;
                        continue block26;
                    }
                    this.add('T');
                    ++this.current;
                    continue block26;
                }
                case 'F': {
                    this.addCode('F', 'F');
                    continue block26;
                }
                case 'G': {
                    if (this.input.charAt(this.current + 1) == 'H') {
                        if (this.current > 0 && !this.isVowel(this.current - 1)) {
                            this.add('K');
                            this.current += 2;
                            continue block26;
                        }
                        if (this.current < 3 && this.current == 0) {
                            if (this.input.charAt(this.current + 2) == 'I') {
                                this.add('J');
                            } else {
                                this.add('K');
                            }
                            this.current += 2;
                            continue block26;
                        }
                        if (this.current > 1 && this.charAt(this.current - 2, BDH) || this.current > 2 && this.charAt(this.current - 3, BDH) || this.current > 3 && this.charAt(this.current - 4, BH)) {
                            this.current += 2;
                            continue block26;
                        }
                        if (this.current > 2 && this.input.charAt(this.current - 1) == 'U' && this.charAt(this.current - 3, CGLRT)) {
                            this.add('F');
                        } else if (this.current > 0 && this.input.charAt(this.current - 1) != 'I') {
                            this.add('K');
                        }
                        this.current += 2;
                        continue block26;
                    }
                    boolean slavoGermanic = this.isSlavoGermanic();
                    if (this.input.charAt(this.current + 1) == 'N') {
                        if (this.current == 1 && this.isVowel(0) && !slavoGermanic) {
                            this.primary.append('K');
                            this.add('N');
                        } else {
                            if (!this.input.regionMatches(this.current + 2, "EY", 0, 2) && this.input.charAt(this.current + 1) != 'Y' && !slavoGermanic) {
                                this.alternate.append('K');
                                this.add('N');
                            } else {
                                this.add('K');
                                this.add('N');
                            }
                            this.current += 2;
                            continue block26;
                        }
                    }
                    if (this.input.regionMatches(this.current + 1, "LI", 0, 2) && !slavoGermanic) {
                        this.primary.append('K');
                        this.add('L');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.current == 0 && (this.input.charAt(this.current + 1) == 'Y' || this.stringAt(this.current + 1, 2, EbEiElEpErEsEyIbIlInIe))) {
                        this.add('K', 'J');
                        this.current += 2;
                        continue block26;
                    }
                    if (!(!this.input.regionMatches(this.current + 1, "ER", 0, 2) && this.input.charAt(this.current + 1) != 'Y' || this.stringAt(0, 6, DangerMangerRanger) || this.charAt(this.current - 1, EI) || this.stringAt(this.current - 1, 3, OgyRgy))) {
                        this.add('K', 'J');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.charAt(this.current + 1, EIY) || this.stringAt(this.current - 1, 4, AggiOggi)) {
                        if (this.stringAt(0, 4, Van_Von_) || this.input.regionMatches(0, "SCH", 0, 3) || this.input.regionMatches(this.current + 1, "ET", 0, 2)) {
                            this.add('K');
                        } else {
                            if (this.input.regionMatches(this.current + 1, "IER ", 0, 4)) {
                                this.add('J');
                            } else {
                                this.add('J', 'K');
                            }
                            this.current += 2;
                            continue block26;
                        }
                    }
                    this.current = this.input.charAt(this.current + 1) == 'G' ? (this.current += 2) : ++this.current;
                    this.add('K');
                    continue block26;
                }
                case 'H': {
                    if ((this.current == 0 || this.isVowel(this.current - 1)) && this.isVowel(this.current + 1)) {
                        this.add('H');
                        this.current += 2;
                        continue block26;
                    }
                    ++this.current;
                    continue block26;
                }
                case 'J': {
                    if (this.stringAt(this.current, 4, "JOSE") || this.stringAt(0, 4, "SAN ")) {
                        if (this.current == 0 && this.input.charAt(this.current + 4) == ' ' || this.stringAt(0, 4, "SAN ")) {
                            this.add('H');
                        } else {
                            this.add('J', 'H');
                        }
                        ++this.current;
                        continue block26;
                    }
                    if (this.current == 0 && !this.stringAt(this.current, 4, "JOSE")) {
                        this.add('J', 'A');
                    } else if (this.isVowel(this.current - 1) && !this.isSlavoGermanic() && (this.input.charAt(this.current + 1) == 'A' || this.input.charAt(this.current + 1) == 'O')) {
                        this.add('J', 'H');
                    } else if (this.current == last) {
                        this.add('J', ' ');
                    } else if (!this.charAt(this.current + 1, BKLMNSTZ) && !this.charAt(this.current - 1, KLS)) {
                        this.add('J');
                    }
                    ++this.current;
                    if (this.input.charAt(this.current) != 'J') continue block26;
                    ++this.current;
                    continue block26;
                }
                case 'K': {
                    this.addCode('K', 'K');
                    continue block26;
                }
                case 'L': {
                    if (this.input.charAt(this.current + 1) == 'L') {
                        if (this.current == length - 3 && this.stringAt(this.current - 1, 4, AlleIllaIllo) || (this.stringAt(last - 1, 2, AsOs) || this.charAt(last, AO)) && this.stringAt(this.current - 1, 4, "ALLE")) {
                            this.primary.append('L');
                            this.current += 2;
                            continue block26;
                        }
                        this.current += 2;
                    } else {
                        ++this.current;
                    }
                    this.add('L');
                    continue block26;
                }
                case 'M': {
                    this.current = this.stringAt(this.current - 1, 3, "UMB") && (this.current + 1 == last || this.stringAt(this.current + 2, 2, "ER")) || this.input.charAt(this.current + 1) == 'M' ? (this.current += 2) : ++this.current;
                    this.add('M');
                    continue block26;
                }
                case 'N': {
                    this.addCode('N', 'N');
                    continue block26;
                }
                case '\u00d1': {
                    ++this.current;
                    this.add('N');
                    continue block26;
                }
                case 'P': {
                    if (this.input.charAt(this.current + 1) == 'H') {
                        this.add('F');
                        this.current += 2;
                        continue block26;
                    }
                    this.current = this.charAt(this.current + 1, BP) ? (this.current += 2) : ++this.current;
                    this.add('P');
                    continue block26;
                }
                case 'Q': {
                    this.addCode('Q', 'K');
                    continue block26;
                }
                case 'R': {
                    if (this.current == last && !this.isSlavoGermanic() && this.stringAt(this.current - 2, 2, "IE") && !this.stringAt(this.current - 4, 2, MaMe)) {
                        this.alternate.append('R');
                    } else {
                        this.add('R');
                    }
                    ++this.current;
                    if (this.input.charAt(this.current) != 'R') continue block26;
                    ++this.current;
                    continue block26;
                }
                case 'S': {
                    if (this.stringAt(this.current - 1, 3, IslYsl)) {
                        ++this.current;
                        continue block26;
                    }
                    if (this.current == 0 && this.stringAt(this.current, 5, "SUGAR")) {
                        this.add('X', 'S');
                        ++this.current;
                        continue block26;
                    }
                    if (this.stringAt(this.current, 2, "SH")) {
                        if (this.stringAt(this.current + 1, 4, HeimHoekHolmHolz)) {
                            this.add('S');
                        } else {
                            this.add('X');
                        }
                        this.current += 2;
                        continue block26;
                    }
                    if (this.stringAt(this.current, 3, SiaSio) || this.stringAt(this.current, 4, "SIAN")) {
                        if (!this.isSlavoGermanic()) {
                            this.add('S', 'X');
                        } else {
                            this.add('S');
                        }
                        this.current += 3;
                        continue block26;
                    }
                    if (this.current == 0 && this.charAt(this.current + 1, LMNW) || this.input.charAt(this.current + 1) == 'Z') {
                        this.add('S', 'X');
                        if (this.input.charAt(this.current + 1) == 'Z') {
                            this.current += 2;
                            continue block26;
                        }
                        ++this.current;
                        continue block26;
                    }
                    if (this.stringAt(this.current, 2, "SC")) {
                        if (this.input.charAt(this.current + 2) == 'H') {
                            if (this.stringAt(this.current + 3, 2, EdEmEnErOoUy)) {
                                if (this.stringAt(this.current + 3, 2, EnEr)) {
                                    this.add('X', 'S');
                                    this.alternate.append('K');
                                } else {
                                    this.add('S');
                                    this.add('K');
                                }
                                this.current += 3;
                                continue block26;
                            }
                            if (this.current == 0 && !this.isVowel(3) && this.input.charAt(3) != 'W') {
                                this.add('X', 'S');
                            } else {
                                this.add('X');
                            }
                            this.current += 3;
                            continue block26;
                        }
                        if (this.charAt(this.current + 2, EIY)) {
                            this.add('S');
                            this.current += 3;
                            continue block26;
                        }
                        this.add('S');
                        this.add('K');
                        this.current += 3;
                        continue block26;
                    }
                    if (this.current == last && this.stringAt(this.current - 2, 2, AiOi)) {
                        this.alternate.append('S');
                    } else {
                        this.add('S');
                    }
                    if (this.charAt(this.current + 1, SZ)) {
                        this.current += 2;
                        continue block26;
                    }
                    ++this.current;
                    continue block26;
                }
                case 'T': {
                    if (this.stringAt(this.current, 4, "TION")) {
                        this.add('X');
                        this.current += 3;
                        continue block26;
                    }
                    if (this.stringAt(this.current, 3, TiaTch)) {
                        this.add('X');
                        this.current += 3;
                        continue block26;
                    }
                    if (this.stringAt(this.current, 2, "TH") || this.stringAt(this.current, 3, "TTH")) {
                        if (this.stringAt(this.current + 2, 2, AmOm) || this.stringAt(0, 4, Van_Von_) || this.stringAt(0, 3, "SCH")) {
                            this.add('T');
                        } else {
                            this.add('0', 'T');
                        }
                        this.current += 2;
                        continue block26;
                    }
                    this.current = this.charAt(this.current + 1, DT) ? (this.current += 2) : ++this.current;
                    this.add('T');
                    continue block26;
                }
                case 'V': {
                    this.addCode('V', 'F');
                    continue block26;
                }
                case 'W': {
                    if (this.stringAt(this.current, 2, "WR")) {
                        this.add('R');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.current == 0 && (this.isVowel(this.current + 1) || this.stringAt(this.current, 2, "WH"))) {
                        if (this.isVowel(this.current + 1)) {
                            this.add('A', 'F');
                        } else {
                            this.add('A');
                        }
                    }
                    if (this.current == last && this.isVowel(this.current - 1) || this.stringAt(this.current - 1, 5, EwskiEwskyOwskiOwsky) || this.stringAt(0, 3, "SCH")) {
                        this.alternate.append('F');
                        ++this.current;
                        continue block26;
                    }
                    if (this.stringAt(this.current, 4, WiczWitz)) {
                        this.add('T', 'F');
                        this.add('S', 'X');
                        this.current += 4;
                        continue block26;
                    }
                    ++this.current;
                    continue block26;
                }
                case 'X': {
                    if (this.current != last || !this.stringAt(this.current - 3, 3, EauIau) && !this.stringAt(this.current - 2, 2, AuOu)) {
                        this.add('K');
                        this.add('S');
                    }
                    if (this.charAt(this.current + 1, CX)) {
                        this.current += 2;
                        continue block26;
                    }
                    ++this.current;
                    continue block26;
                }
                case 'Z': {
                    if (this.input.charAt(this.current + 1) == 'H') {
                        this.add('J');
                        this.current += 2;
                        continue block26;
                    }
                    if (this.stringAt(this.current + 1, 2, ZaZiZo) || this.isSlavoGermanic() && this.current > 0 && this.input.charAt(this.current - 1) != 'T') {
                        this.alternate.append('T');
                        this.add('S');
                    } else {
                        this.add('S');
                    }
                    if (this.input.charAt(this.current + 1) == 'Z') {
                        this.current += 2;
                        continue block26;
                    }
                    ++this.current;
                    continue block26;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.add(this.input.charAt(this.current));
                    ++this.current;
                    continue block26;
                }
            }
            ++this.current;
        }
        if (this.primary.length() > this.encodeLimit) {
            this.primary.delete(this.encodeLimit, this.primary.length());
        }
        if (this.alternate.length() > this.encodeLimit) {
            this.alternate.delete(this.encodeLimit, this.alternate.length());
        }
        return this.primary.toString();
    }
}

