/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.outputter;

import edu.northwestern.at.morphadorner.corpuslinguistics.outputter.AdornedWordOutputter;
import edu.northwestern.at.utils.FileUtils;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;

public class PrintStreamAdornedWordOutputter
implements AdornedWordOutputter {
    protected PrintStream printStream = null;
    protected char separatorCharacter = (char)9;
    protected String fileName = null;
    protected String fileEncoding = "utf-8";
    protected String[] wordAttributeNames;

    @Override
    public void createOutputFile(String fileName, String encoding, char separatorCharacter) throws IOException {
        if (!FileUtils.createPathForFile(fileName)) {
            throw new IOException("Unable to create output directory.");
        }
        this.fileName = fileName;
        this.fileEncoding = encoding;
        this.separatorCharacter = separatorCharacter;
        FileOutputStream outputStream = new FileOutputStream(fileName, false);
        String safeEncoding = encoding == null ? "" : encoding;
        this.printStream = safeEncoding.length() > 0 ? new PrintStream((OutputStream)new BufferedOutputStream(outputStream), true, encoding) : new PrintStream(new BufferedOutputStream(outputStream), true);
    }

    @Override
    public void setWordAttributeNames(List<String> wordAttributeNames) {
        this.wordAttributeNames = new String[wordAttributeNames.size()];
        for (int i = 0; i < wordAttributeNames.size(); ++i) {
            this.wordAttributeNames[i] = wordAttributeNames.get(i);
        }
    }

    @Override
    public void outputWordAndAdornments(String[] wordAndAdornments) throws IOException {
        for (int i = 0; i < wordAndAdornments.length; ++i) {
            if (i > 0) {
                this.printStream.print(this.separatorCharacter);
            }
            this.printStream.print(wordAndAdornments[i]);
        }
        this.printStream.println("");
    }

    @Override
    public void outputWordAndAdornments(List<String> wordAndAdornments) throws IOException {
        for (int i = 0; i < wordAndAdornments.size(); ++i) {
            if (i > 0) {
                this.printStream.print(this.separatorCharacter);
            }
            this.printStream.print(wordAndAdornments.get(i));
        }
        this.printStream.println("");
    }

    @Override
    public String getOutputFileName() {
        return this.fileName;
    }

    @Override
    public String getOutputFileEncoding() {
        return this.fileEncoding;
    }

    @Override
    public void close() {
        if (this.printStream != null) {
            try {
                this.printStream.flush();
                this.printStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

