/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.ngram;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class WordCountExtractor {
    protected Map<String, Integer> wordCounts = new TreeMap<String, Integer>();
    String[] words = null;
    protected String[] uniqueWords = null;

    public void countWords(String[] words) {
        this.words = (String[])words.clone();
        this.computeWordCounts();
    }

    public void countWords(List<String> wordList) {
        int nWords = wordList.size();
        this.words = new String[nWords];
        for (int i = 0; i < nWords; ++i) {
            this.words[i] = wordList.get(i);
        }
        this.computeWordCounts();
    }

    protected void computeWordCounts() {
        for (int i = 0; i < this.words.length; ++i) {
            String word = this.words[i];
            if (this.wordCounts.containsKey(word)) {
                int freq = this.wordCounts.get(word);
                this.wordCounts.put(word, new Integer(++freq));
                continue;
            }
            this.wordCounts.put(word, new Integer(1));
        }
        int nUniqueWords = this.wordCounts.size();
        this.uniqueWords = new String[nUniqueWords];
        Set<String> keyset = this.wordCounts.keySet();
        Iterator<String> iterator = keyset.iterator();
        for (int i = 0; i < nUniqueWords; ++i) {
            this.uniqueWords[i] = iterator.next();
        }
    }

    public String[] getWords() {
        return this.words;
    }

    public int getNumberOfWords() {
        return this.words.length;
    }

    public String[] getUniqueWords() {
        return this.uniqueWords;
    }

    public int getNumberOfUniqueWords() {
        return this.uniqueWords.length;
    }

    public int getWordCount(String word) {
        int result = 0;
        if (this.wordCounts.containsKey(word)) {
            Integer count = this.wordCounts.get(word);
            result = count;
        }
        return result;
    }

    public Map getWordCounts() {
        return this.wordCounts;
    }

    public void reset() {
        this.wordCounts.clear();
        this.words = null;
        this.uniqueWords = null;
    }
}

