/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.namestandardizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.namestandardizer.DefaultNameStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.namestandardizer.NameStandardizer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class NameStandardizerFactory {
    public static NameStandardizer newNameStandardizer() {
        String className = System.getProperty("namestandardizer.class");
        if (className == null) {
            className = "DefaultNameStandardizer";
        }
        return NameStandardizerFactory.newNameStandardizer(className);
    }

    public static NameStandardizer newNameStandardizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("namestandardizer.class");
        }
        if (className == null) {
            className = "DefaultNameStandardizer";
        }
        return NameStandardizerFactory.newNameStandardizer(className);
    }

    public static NameStandardizer newNameStandardizer(String className) {
        NameStandardizer nameStandardizer = null;
        try {
            nameStandardizer = (NameStandardizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(NameStandardizerFactory.class.getName()) + "." + className;
            try {
                nameStandardizer = (NameStandardizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create name standardizer of class " + fixedClassName + ", using default.");
                nameStandardizer = new DefaultNameStandardizer();
            }
        }
        return nameStandardizer;
    }
}

