/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.namestandardizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.DefaultLexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.namestandardizer.NameStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.morphadorner.corpuslinguistics.stringsimilarity.LetterPairSimilarity;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.ScoredString;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.TernaryTrie;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractNameStandardizer
extends IsCloseableObject
implements NameStandardizer,
UsesLogger {
    protected static TernaryTrie nameTrie;
    protected static TernaryTrie consonantTrie;
    protected Logger logger = new DummyLogger();

    public AbstractNameStandardizer() {
        nameTrie = new TernaryTrie();
        consonantTrie = new TernaryTrie();
    }

    @Override
    public void loadNames(String lexiconFileName) throws IOException {
        DefaultLexicon lexicon = new DefaultLexicon();
        lexicon.loadLexicon(new File(lexiconFileName).toURI().toURL(), "utf-8");
        this.loadNamesFromLexicon(lexicon);
    }

    @Override
    public void loadNamesFromLexicon(Lexicon lexicon) throws IOException {
        if (lexicon != null) {
            PartOfSpeechTags posTags = lexicon.getPartOfSpeechTags();
            String singularTag = posTags.getSingularProperNounTag();
            String pluralTag = posTags.getPluralProperNounTag();
            String[] entries = lexicon.getEntries();
            for (int i = 0; i < entries.length; ++i) {
                String entry = entries[i];
                Set<String> categories = lexicon.getCategoriesForEntry(entry);
                if (!categories.contains(singularTag) && !categories.contains(pluralTag)) continue;
                String lcEntry = entry.toLowerCase();
                nameTrie.put(lcEntry, lcEntry);
                String noVowels = StringUtils.stripChars(lcEntry, "aeiouy");
                TreeSet<String> names = (TreeSet<String>)consonantTrie.get(noVowels);
                if (names == null) {
                    names = new TreeSet<String>();
                    names.add(lcEntry);
                    consonantTrie.put(noVowels, names);
                    continue;
                }
                names.add(lcEntry);
            }
        }
    }

    @Override
    public void loadNames(Collection<String> properNamesCollection) {
        if (properNamesCollection != null) {
            for (String properName : properNamesCollection) {
                String lcProperName = properName.toLowerCase();
                nameTrie.put(lcProperName, lcProperName);
                String noVowels = StringUtils.stripChars(lcProperName, "aeiouy");
                TreeSet<String> names = (TreeSet<String>)consonantTrie.get(noVowels);
                if (names == null) {
                    names = new TreeSet<String>();
                    names.add(lcProperName);
                    consonantTrie.put(noVowels, names);
                    continue;
                }
                names.add(lcProperName);
            }
        }
    }

    @Override
    public int getNumberOfNames() {
        return nameTrie.size();
    }

    @Override
    public boolean dontStandardize(String properName) {
        return properName.indexOf(".") >= 0;
    }

    @Override
    public String standardizeProperName(String properName) {
        if (this.dontStandardize(properName)) {
            return properName;
        }
        String result = this.preprocessProperName(properName);
        String lcName = result.toLowerCase();
        List<String> nearNames = nameTrie.nearSearch(lcName, 2);
        SortedArrayList<ScoredString> scoredNames = new SortedArrayList<ScoredString>();
        if (nearNames.size() > 0) {
            for (int j = 0; j < nearNames.size(); ++j) {
                double similarity = LetterPairSimilarity.letterPairSimilarity(lcName, nearNames.get(j));
                scoredNames.add(new ScoredString(nearNames.get(j), similarity));
            }
        } else {
            String noVowels = StringUtils.stripChars(lcName, "aeiouy");
            nearNames = consonantTrie.nearSearch(noVowels, 3);
            for (int j = 0; j < nearNames.size(); ++j) {
                Set nearNamesSet = (Set)consonantTrie.get(nearNames.get(j));
                for (String name : nearNamesSet) {
                    double similarity = LetterPairSimilarity.letterPairSimilarity(lcName, name);
                    if (!(similarity >= 0.75)) continue;
                    scoredNames.add(new ScoredString(name, similarity));
                }
            }
        }
        if (scoredNames.size() > 0) {
            result = ((ScoredString)scoredNames.get(0)).getString();
            result = CharUtils.makeCaseMatch(result, properName);
        }
        return result;
    }

    @Override
    public String preprocessProperName(String properName) {
        return properName;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

