/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer.DefaultNameRecognizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer.NameRecognizer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class NameRecognizerFactory {
    public static NameRecognizer newNameRecognizer() {
        String className = System.getProperty("namerecognizer.class");
        if (className == null) {
            className = "DefaultNameRecognizer";
        }
        return NameRecognizerFactory.newNameRecognizer(className);
    }

    public static NameRecognizer newNameRecognizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("namerecognizer.class");
        }
        if (className == null) {
            className = "DefaultNameRecognizer";
        }
        return NameRecognizerFactory.newNameRecognizer(className);
    }

    public static NameRecognizer newNameRecognizer(String className) {
        NameRecognizer nameRecognizer = null;
        try {
            nameRecognizer = (NameRecognizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(NameRecognizer.class.getName()) + "." + className;
            try {
                nameRecognizer = (NameRecognizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create name recognizer of class " + fixedClassName + ", using default.");
                nameRecognizer = new DefaultNameRecognizer();
            }
        }
        return nameRecognizer;
    }
}

