/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.lexicon;

import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.DefaultLexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class LexiconFactory {
    public static Lexicon newLexicon() {
        String className = System.getProperty("lexicon.class");
        if (className == null) {
            className = "DefaultLexicon";
        }
        return LexiconFactory.newLexicon(className);
    }

    public static Lexicon newLexicon(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("lexicon.class");
        }
        if (className == null) {
            className = "DefaultLexicon";
        }
        return LexiconFactory.newLexicon(className);
    }

    public static Lexicon newLexicon(String className) {
        Lexicon lexicon = null;
        try {
            lexicon = (Lexicon)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(LexiconFactory.class.getName()) + "." + className;
            try {
                lexicon = (Lexicon)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create lexicon of class " + fixedClassName + ", using default.");
                try {
                    lexicon = new DefaultLexicon();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return lexicon;
    }
}

