/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer.DefaultLemmatizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer.Lemmatizer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class LemmatizerFactory {
    public static Lemmatizer newLemmatizer() {
        String className = System.getProperty("lemmatizer.class");
        if (className == null) {
            className = "DefaultLemmatizer";
        }
        return LemmatizerFactory.newLemmatizer(className);
    }

    public static Lemmatizer newLemmatizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("lemmatizer.class");
        }
        if (className == null) {
            className = "DefaultLemmatizer";
        }
        return LemmatizerFactory.newLemmatizer(className);
    }

    public static Lemmatizer newLemmatizer(String className) {
        Lemmatizer lemmatizer = null;
        try {
            lemmatizer = (Lemmatizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(LemmatizerFactory.class.getName()) + "." + className;
            try {
                lemmatizer = (Lemmatizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create lemmatizer of class " + fixedClassName + ", using default.");
                try {
                    lemmatizer = new DefaultLemmatizer();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return lemmatizer;
    }
}

