/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer.AbstractLemmatizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer.Lemmatizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.stemmer.Stemmer;
import edu.northwestern.at.utils.IsCloseable;
import edu.northwestern.at.utils.MapFactory;
import java.util.Map;

public abstract class AbstractStemmerLemmatizer
extends AbstractLemmatizer
implements IsCloseable,
Lemmatizer {
    protected Stemmer stemmer = null;
    protected Map<String, String> stemMap = MapFactory.createNewMap();

    @Override
    public void setLexicon(Lexicon lexicon) {
    }

    @Override
    public String lemmatize(String spelling, String wordClass) {
        String result = "*";
        if (this.stemMap.containsKey(spelling)) {
            result = this.stemMap.get(spelling);
        } else {
            result = this.stemmer.stem(spelling);
            this.stemMap.put(spelling, result);
        }
        return result;
    }

    @Override
    public String lemmatize(String spelling) {
        return this.lemmatize(spelling, "");
    }
}

