/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.inputter;

import edu.northwestern.at.morphadorner.corpuslinguistics.inputter.DefaultTextInputter;
import edu.northwestern.at.morphadorner.corpuslinguistics.inputter.TextInputter;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class TextInputterFactory {
    public static TextInputter newTextInputter() {
        String className = System.getProperty("textinputter.class");
        if (className == null) {
            className = "DefaultTextInputter";
        }
        return TextInputterFactory.newTextInputter(className);
    }

    public static TextInputter newTextInputter(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("textinputter.class");
        }
        if (className == null) {
            className = "DefaultTextInputter";
        }
        return TextInputterFactory.newTextInputter(className);
    }

    public static TextInputter newTextInputter(String className) {
        TextInputter textInputter = null;
        try {
            textInputter = (TextInputter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(TextInputterFactory.class.getName()) + "." + className;
            try {
                textInputter = (TextInputter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create text inputter of class " + fixedClassName + ", using default.");
                textInputter = new DefaultTextInputter();
            }
        }
        return textInputter;
    }
}

