/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.inputter;

import edu.northwestern.at.morphadorner.corpuslinguistics.inputter.TextInputter;
import edu.northwestern.at.morphadorner.corpuslinguistics.inputter.XMLTextInputter;
import edu.northwestern.at.utils.FileUtils;
import java.io.File;
import java.io.IOException;

public class DiskBasedXMLTextInputter
extends XMLTextInputter
implements TextInputter {
    public DiskBasedXMLTextInputter() {
        this.storesSegmentFiles = true;
    }

    @Override
    public void setSegmentText(int segmentNumber, File segmentTextFile) {
        if (segmentNumber >= 0 && segmentNumber < this.segmentNames.size()) {
            this.segmentMap.put((String)this.segmentNames.get(segmentNumber), segmentTextFile.getAbsolutePath());
        }
    }

    @Override
    public void setSegmentText(String segmentName, File segmentTextFile) {
        if (segmentName != null && this.segmentMap.containsKey(segmentName)) {
            this.segmentMap.put(segmentName, segmentTextFile.getAbsolutePath());
        }
    }

    @Override
    protected String getSegment(String segmentName) {
        String result = "";
        if (this.segmentMap.containsKey(segmentName)) {
            String fileName = (String)this.segmentMap.get(segmentName);
            try {
                result = FileUtils.readTextFile(fileName, this.encoding);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    protected void putSegment(String segmentName, String segmentText) {
        String fileName = null;
        if (this.segmentMap.containsKey(segmentName)) {
            fileName = (String)this.segmentMap.get(segmentName);
        } else {
            try {
                File file = File.createTempFile("mad", null);
                file.deleteOnExit();
                fileName = file.getAbsolutePath();
                this.segmentMap.put(segmentName, fileName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (fileName != null) {
            try {
                FileUtils.writeTextFile(fileName, false, segmentText.replaceAll("[\r\n]", " "), this.encoding);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        if (this.segmentMap != null) {
            for (String fileName : this.segmentMap.keySet()) {
                FileUtils.deleteFile(fileName);
            }
        }
        super.close();
    }

    @Override
    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

