/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.inflector.pluralizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.pluralizer.RuleBasedPluralizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.wordrule.AbstractRegexReplacementRule;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.wordrule.CategoryInflectionRule;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.wordrule.IrregularMappingRule;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.wordrule.RegexReplacementRule;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.wordrule.SuffixInflectionRule;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.wordrule.WordRule;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;

public class EnglishPluralizer
extends RuleBasedPluralizer {
    protected static final String POSTFIX_ADJECTIVE_REGEX = "((?!major|lieutenant|brigadier|adjutant)\\S+(?=(?:-|\\s+)general)|court(?=(?:-|\\s+)martial))(.*)";
    protected static final String[] PREPOSITIONS = new String[]{"about", "above", "across", "after", "among", "around", "at", "athwart", "before", "behind", "below", "beneath", "beside", "besides", "between", "betwixt", "beyond", "but", "by", "during", "except", "for", "from", "in", "into", "near", "of", "off", "on", "onto", "out", "over", "since", "till", "to", "under", "until", "unto", "upon", "with"};
    protected static final Map<String, String> NOMINATIVE_PRONOUNS = IrregularMappingRule.toMap(new String[][]{{"i", "we"}, {"myself", "ourselves"}, {"you", "you"}, {"yourself", "yourselves"}, {"she", "they"}, {"herself", "themselves"}, {"he", "they"}, {"himself", "themselves"}, {"it", "they"}, {"itself", "themselves"}, {"they", "they"}, {"themself", "themselves"}, {"mine", "ours"}, {"yours", "yours"}, {"hers", "theirs"}, {"his", "theirs"}, {"its", "theirs"}, {"theirs", "theirs"}});
    protected static final Map<String, String> ACCUSATIVE_PRONOUNS = IrregularMappingRule.toMap(new String[][]{{"me", "us"}, {"myself", "ourselves"}, {"you", "you"}, {"yourself", "yourselves"}, {"her", "them"}, {"herself", "themselves"}, {"him", "them"}, {"himself", "themselves"}, {"it", "them"}, {"itself", "themselves"}, {"them", "them"}, {"themself", "themselves"}});
    protected static final Map<String, String> IRREGULAR_NOUNS = IrregularMappingRule.toMap(new String[][]{{"child", "children"}, {"brother", "brothers"}, {"loaf", "loaves"}, {"hoof", "hoofs"}, {"beef", "beefs"}, {"money", "monies"}, {"mongoose", "mongooses"}, {"ox", "oxen"}, {"cow", "cows"}, {"soliloquy", "soliloquies"}, {"graffito", "graffiti"}, {"prima donna", "prima donnas"}, {"octopus", "octopuses"}, {"genie", "genies"}, {"ganglion", "ganglions"}, {"trilby", "trilbys"}, {"turf", "turfs"}, {"numen", "numina"}, {"atman", "atmas"}, {"occiput", "occiputs"}, {"corpus", "corpuses"}, {"opus", "opuses"}, {"genus", "genera"}, {"mythos", "mythoi"}, {"penis", "penises"}, {"testis", "testes"}, {"atlas", "atlases"}});
    protected static final String[] CATEGORY_UNINFLECTED_NOUNS = new String[]{".*fish", "tuna", "salmon", "mackerel", "trout", "bream", "sea[- ]bass", "carp", "cod", "flounder", "whiting", ".*deer", ".*sheep", "wildebeest", "swine", "eland", "bison", "buffalo", "elk", "moose", "rhinoceros", "Amoyese", "Beninese", "Bhutanese", "Borghese", "Burmese", "Chinese", "Congoese", "Congolese", "Faroese", "Foochowese", "Gabonese", "Genevese", "Genoese", "Gilbertese", "Guyanese", "Hottentotese", "Japanese", "Kiplingese", "Kongoese", "Lebanese", "Lucchese", "Maltese", "Marshallese", "Nankingese", "Nepalese", "Niasese", "Pekingese", "Piedmontese", "Pistoiese", "Portuguese", "Sammarinese", "Sarawakese", "Senegalese", "Shavese", "Sudanese", "Togolese", "Vermontese", "Vietnamese", "Wenchowese", "Yengeese", ".*[nrlm]ese", "British", "Burkinabe", "French", "I-Kiribati", "Irish", "Mahorais", "Malagasy", "Ni-Vanuatu", "Seychellois", "Spanish", "Swiss", "Taiwan", "Thai", ".*pox", "graffiti", "djinn", "breeches", "britches", "clippers", "gallows", "hijinks", "headquarters", "pliers", "scissors", "testes", "herpes", "pincers", "shears", "proceedings", "trousers", "cantus", "coitus", "nexus", "contretemps", "corps", "debris", ".*ois", "siemens", ".*measles", "mumps", "diabetes", "jackanapes", "series", "species", "rabies", "chassis", "innings", "news", "mews"};
    protected static final String[] CATEGORY_MAN_MANS_RULE = new String[]{"human", "Alabaman", "Bahaman", "Burman", "German", "Hiroshiman", "Liman", "Nakayaman", "Oklahoman", "Panaman", "Selman", "Sonaman", "Tacoman", "Yakiman", "Yokohaman", "Yuman"};
    protected static final String[] CATEGORY_EX_ICES_RULE = new String[]{"codex", "index", "murex", "silex", "vertex"};
    protected static final String[] CATEGORY_IX_ICES_RULE = new String[]{"appendix", "radix", "helix", "matrix"};
    protected static final String[] CATEGORY_UM_A_RULE = new String[]{"bacterium", "agendum", "desideratum", "erratum", "stratum", "datum", "ovum", "extremum", "candelabrum"};
    protected static final String[] CLASSICAL_UM_A = new String[]{"maximum", "minimum", "momentum", "optimum", "quantum", "cranium", "curriculum", "dictum", "phylum", "aquarium", "compendium", "emporium", "enconium", "gymnasium", "honorarium", "interregnum", "lustrum", "memorandum", "millennium", "rostrum", "spectrum", "speculum", "stadium", "trapezium", "ultimatum", "medium", "vacuum", "velum", "consortium"};
    protected static final String[] CATEGORY_US_I_RULE = new String[]{"alumnus", "alveolus", "bacillus", "bronchus", "locus", "nucleus", "stimulus", "meniscus"};
    protected static final String[] CLASSICAL_US_I_RULE = new String[]{"focus", "radius", "genius", "incubus", "succubus", "nimbus", "fungus", "nucleolus", "stylus", "torus", "umbilicus", "uterus", "hippopotamus"};
    protected static final String[] CLASSICAL_US_US_RULE = new String[]{"status", "apparatus", "prospectus", "sinus", "hiatus", "impetus", "plexus"};
    protected static final String[] CATEGORY_ON_A_RULE = new String[]{"criterion", "perihelion", "aphelion", "phenomenon", "prolegomenon", "noumenon", "organon", "asyndeton", "hyperbaton"};
    protected static final String[] CLASSICAL_ON_A_RULE = new String[]{"oxymoron"};
    protected static final String[] CLASSICAL_A_ATA_RULE = new String[]{"anathema", "bema", "carcinoma", "charisma", "diploma", "dogma", "drama", "edema", "enema", "enigma", "lemma", "lymphoma", "magma", "melisma", "miasma", "oedema", "sarcoma", "schema", "soma", "stigma", "stoma", "trauma", "gumma", "pragma"};
    protected static final String[] CATEGORY_A_AE_RULE = new String[]{"alumna", "alga", "vertebra", "persona"};
    protected static final String[] CLASSICAL_A_AE_RULE = new String[]{"amoeba", "antenna", "formula", "hyperbola", "medusa", "nebula", "parabola", "abscissa", "hydra", "nova", "lacuna", "aurora", ".*umbra", "flora", "fauna"};
    protected static final String[] CLASSICAL_EN_INA_RULE = new String[]{"stamen", "foramen", "lumen"};
    protected static final String[] CLASSICAL_O_I_RULE = new String[]{"solo", "soprano", "basso", "alto", "contralto", "tempo", "piano", "virtuoso"};
    protected static final String[] CATEGORY_O_OS_RULE = new String[]{"albino", "archipelago", "armadillo", "commando", "crescendo", "fiasco", "ditto", "dynamo", "embryo", "ghetto", "guano", "inferno", "jumbo", "lumbago", "magneto", "manifesto", "medico", "octavo", "photo", "pro", "quarto", "canto", "lingo", "generalissimo", "stylo", "rhino", "casino", "auto", "macro", "zero", "solo", "soprano", "basso", "alto", "contralto", "tempo", "piano", "virtuoso"};
    protected static final String[] CATEGORY_SINGULAR_S_RULE = new String[]{".*ss", "acropolis", "aegis", "alias", "asbestos", "bathos", "bias", "bronchitis", "bursitis", "caddis", "cannabis", "canvas", "chaos", "cosmos", "dais", "digitalis", "epidermis", "ethos", "eyas", "gas", "glottis", "hubris", "ibis", "lens", "mantis", "marquis", "metropolis", "pathos", "pelvis", "polis", "rhinoceros", "sassafras", "trellis", ".*us", "[A-Z].*es", "ephemeris", "iris", "clitoris", "chrysalis", "epididymis", ".*itis"};
    protected static final String[] CLASSICAL_EIX_ICES_RULE = new String[]{"vortex", "vertex", "cortex", "latex", "pontifex", "apex", "index", "simplex"};
    protected final List<WordRule> rules = Arrays.asList(new RegexReplacementRule("^(\\s)$", "$1"), new CategoryInflectionRule(CATEGORY_UNINFLECTED_NOUNS, "-", "-"), new AbstractRegexReplacementRule("(?i)^(?:((?!major|lieutenant|brigadier|adjutant)\\S+(?=(?:-|\\s+)general)|court(?=(?:-|\\s+)martial))(.*))$"){

        @Override
        public String replace(Matcher m) {
            return EnglishPluralizer.this.pluralize(m.group(1)) + m.group(2);
        }
    }, new AbstractRegexReplacementRule("(?i)(.*?)((?:-|\\s+)(?:" + AbstractRegexReplacementRule.disjunction(PREPOSITIONS) + "|d[eu])(?:-|\\s+))a(?:-|\\s+)(.*)"){

        @Override
        public String replace(Matcher m) {
            return EnglishPluralizer.this.pluralize(m.group(1)) + m.group(2) + EnglishPluralizer.this.pluralize(m.group(3));
        }
    }, new AbstractRegexReplacementRule("(?i)(.*?)((-|\\s+)(" + AbstractRegexReplacementRule.disjunction(PREPOSITIONS) + "|d[eu])((-|\\s+)(.*))?)"){

        @Override
        public String replace(Matcher m) {
            return EnglishPluralizer.this.pluralize(m.group(1)) + m.group(2);
        }
    }, new IrregularMappingRule(NOMINATIVE_PRONOUNS, "(?i)" + AbstractRegexReplacementRule.disjunction(NOMINATIVE_PRONOUNS.keySet())), new IrregularMappingRule(ACCUSATIVE_PRONOUNS, "(?i)" + AbstractRegexReplacementRule.disjunction(ACCUSATIVE_PRONOUNS.keySet())), new IrregularMappingRule(ACCUSATIVE_PRONOUNS, "(?i)(" + AbstractRegexReplacementRule.disjunction(PREPOSITIONS) + "\\s)" + "(" + AbstractRegexReplacementRule.disjunction(ACCUSATIVE_PRONOUNS.keySet()) + ")"){

        @Override
        public String replace(Matcher m) {
            return m.group(1) + (String)this.mappings.get(m.group(2).toLowerCase());
        }
    }, new IrregularMappingRule(IRREGULAR_NOUNS, "(?i)(.*)\\b" + AbstractRegexReplacementRule.disjunction(IRREGULAR_NOUNS.keySet()) + "$"), new CategoryInflectionRule(CATEGORY_MAN_MANS_RULE, "-man", "-mans"), new RegexReplacementRule("(?i)(\\S*)(person)$", "$1people"), new SuffixInflectionRule("-man", "-man", "-men"), new SuffixInflectionRule("-[lm]ouse", "-ouse", "-ice"), new SuffixInflectionRule("-tooth", "-tooth", "-teeth"), new SuffixInflectionRule("-goose", "-goose", "-geese"), new SuffixInflectionRule("-foot", "-foot", "-feet"), new SuffixInflectionRule("-ceps", "-", "-"), new SuffixInflectionRule("-zoon", "-zoon", "-zoa"), new SuffixInflectionRule("-[csx]is", "-is", "-es"), new CategoryInflectionRule(CATEGORY_EX_ICES_RULE, "-ex", "-ices"), new CategoryInflectionRule(CATEGORY_IX_ICES_RULE, "-ix", "-ices"), new CategoryInflectionRule(CATEGORY_UM_A_RULE, "-um", "-a"), new CategoryInflectionRule(CATEGORY_US_I_RULE, "-us", "-i"), new CategoryInflectionRule(CATEGORY_ON_A_RULE, "-on", "-a"), new CategoryInflectionRule(CATEGORY_A_AE_RULE, "-a", "-ae"), new CategoryInflectionRule(CATEGORY_SINGULAR_S_RULE, "-s", "-ses"), new RegexReplacementRule("^([A-Z].*s)$", "$1es"), new SuffixInflectionRule("-[cs]h", "-h", "-hes"), new SuffixInflectionRule("-x", "-x", "-xes"), new SuffixInflectionRule("-z", "-z", "-zes"), new SuffixInflectionRule("-[aeo]lf", "-f", "-ves"), new SuffixInflectionRule("-[^d]eaf", "-f", "-ves"), new SuffixInflectionRule("-arf", "-f", "-ves"), new SuffixInflectionRule("-[nlw]ife", "-fe", "-ves"), new SuffixInflectionRule("-[aeiou]y", "-y", "-ys"), new RegexReplacementRule("^([A-Z].*y)$", "$1s"), new SuffixInflectionRule("-y", "-y", "-ies"), new CategoryInflectionRule(CATEGORY_O_OS_RULE, "-o", "-os"), new SuffixInflectionRule("-[aeiou]o", "-o", "-os"), new SuffixInflectionRule("-o", "-o", "-oes"), new SuffixInflectionRule("-", "-s"));

    public EnglishPluralizer() {
        this.setRules(this.rules);
        this.setLocale(Locale.ENGLISH);
    }

    @Override
    protected String postProcess(String trimmedWord, String pluralizedWord) {
        if (trimmedWord.matches("^I$")) {
            return pluralizedWord;
        }
        return super.postProcess(trimmedWord, pluralizedWord);
    }
}

