/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.inflector.conjugator;

import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.conjugator.Conjugator;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.conjugator.DefaultConjugator;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class ConjugatorFactory {
    public static Conjugator newConjugator() {
        String className = System.getProperty("conjugator.class");
        if (className == null) {
            className = "DefaultConjugator";
        }
        return ConjugatorFactory.newConjugator(className);
    }

    public static Conjugator newConjugator(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("conjugator.class");
        }
        if (className == null) {
            className = "DefaultConjugator";
        }
        return ConjugatorFactory.newConjugator(className);
    }

    public static Conjugator newConjugator(String className) {
        Conjugator conjugator = null;
        try {
            conjugator = (Conjugator)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(ConjugatorFactory.class.getName()) + "." + className;
            try {
                conjugator = (Conjugator)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create conjugator of class " + fixedClassName + ", using default.");
                try {
                    conjugator = new DefaultConjugator();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return conjugator;
    }
}

