/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.inflector;

import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.DefaultInflector;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.Inflector;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class InflectorFactory {
    public static Inflector newInflector() {
        String className = System.getProperty("inflector.class");
        if (className == null) {
            className = "DefaultInflector";
        }
        return InflectorFactory.newInflector(className);
    }

    public static Inflector newInflector(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("inflector.class");
        }
        if (className == null) {
            className = "DefaultInflector";
        }
        return InflectorFactory.newInflector(className);
    }

    public static Inflector newInflector(String className) {
        Inflector inflector = null;
        try {
            inflector = (Inflector)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(Inflector.class.getName()) + "." + className;
            try {
                inflector = (Inflector)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create inflector of class " + fixedClassName + ", using default.");
                try {
                    inflector = new DefaultInflector();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return inflector;
    }
}

