/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.hyphenator;

import edu.northwestern.at.morphadorner.corpuslinguistics.hyphenator.Hyphenator;
import java.io.FileInputStream;
import java.io.InputStream;

public class BaseHyphenator
implements Hyphenator {
    protected static String ukhyphenPath = "resources/ukhyphen.tex";
    protected static String ushyphenPath = "resources/hyphen.tex";
    protected net.davidashen.text.Hyphenator texHyphenator;

    public BaseHyphenator() {
        try {
            this.texHyphenator = new net.davidashen.text.Hyphenator();
            this.texHyphenator.loadTable(BaseHyphenator.class.getResourceAsStream(ukhyphenPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadHyphenationRules(InputStream hyphenRulesStream) throws Exception {
        this.texHyphenator.loadTable(hyphenRulesStream);
    }

    public void loadHyphenationRules(String hyphenRulesFileName) throws Exception {
        FileInputStream fis = new FileInputStream(hyphenRulesFileName);
        this.texHyphenator.loadTable((InputStream)fis);
        fis.close();
    }

    @Override
    public String hyphenate(String word) {
        return this.texHyphenator.hyphenate(word);
    }
}

