/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.abbreviations;

import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.UTF8Properties;
import edu.northwestern.at.utils.UTF8PropertyUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Abbreviations {
    public static String defaultAbbreviationPattern = "([A-Za-z]\\.([A-Za-z0-9]\\.)+|[A-Z]\\.|[A-Z][bcdfghj-np-tvxz]+\\.)";
    protected static Pattern abbreviationPattern = Pattern.compile("^" + defaultAbbreviationPattern + "$");
    protected static Matcher abbreviationMatcher = abbreviationPattern.matcher("");
    protected static Pattern initialPattern = Pattern.compile("[A-Z][.]");
    protected static Matcher initialMatcher = initialPattern.matcher("");
    protected static Pattern possessiveInitialPattern = Pattern.compile("[A-Z][.]'[s|S]");
    protected static Matcher possessiveInitialMatcher = possessiveInitialPattern.matcher("");
    protected UTF8Properties abbreviations = null;
    protected static final String defaultAbbreviationsFileName = "resources/en-abbrevs.properties";

    public Abbreviations() {
        this.abbreviations = Abbreviations.loadAbbreviationsFromResource("en");
    }

    public Abbreviations(String langCode) {
        this.abbreviations = Abbreviations.loadAbbreviationsFromResource(langCode);
    }

    public static UTF8Properties loadAbbreviationsFromResource(String langCode) {
        UTF8Properties result = new UTF8Properties();
        try {
            result.load(Abbreviations.class.getResourceAsStream("resources/" + langCode + "-abbrevs.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean loadAbbreviations(String abbreviationsURL) {
        boolean result = false;
        if (this.abbreviations == null) {
            this.abbreviations = new UTF8Properties();
        }
        try {
            UTF8Properties newAbbreviations = UTF8PropertyUtils.loadUTF8Properties(new URL(abbreviationsURL));
            Enumeration<?> enumeration = newAbbreviations.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                this.abbreviations.put(key, newAbbreviations.getProperty(key));
            }
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isKnownAbbreviation(String str) {
        return this.abbreviations.containsKey(str);
    }

    public boolean isAbbreviation(String str) {
        boolean result = this.isKnownAbbreviation(str);
        if (!result) {
            abbreviationMatcher.reset(str);
            result = abbreviationMatcher.matches();
        }
        return result;
    }

    public boolean isEOSAbbreviation(String str) {
        return this.abbreviations.getProperty(str, "0").equals("1");
    }

    public static boolean isInitial(String str) {
        initialMatcher.reset(str);
        return initialMatcher.matches();
    }

    public static boolean isPossessiveInitial(String str) {
        possessiveInitialMatcher.reset(str);
        return possessiveInitialMatcher.matches();
    }

    public int getAbbreviationsCount() {
        int result = 0;
        if (this.abbreviations != null) {
            result = this.abbreviations.size();
        }
        return result;
    }

    public UTF8Properties getAbbreviations() {
        return this.abbreviations;
    }

    public static String createAbbreviationsPattern(UTF8Properties abbreviations) {
        String result = defaultAbbreviationPattern;
        if (abbreviations != null && abbreviations.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            int i = 0;
            Enumeration<?> enumeration = abbreviations.propertyNames();
            while (enumeration.hasMoreElements()) {
                String abbrev = (String)enumeration.nextElement();
                if (i++ > 0) {
                    sb.append("|");
                }
                abbrev = StringUtils.replaceAll(abbrev, ".", "\\.");
                sb.append(abbrev);
            }
            sb.append(")");
            result = sb.toString();
        }
        return result;
    }
}

