/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.corpuslinguistics.sentencemelder.XMLSentenceMelder;
import edu.northwestern.at.utils.QueueStack;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.xml.ExtendedXMLFilterImpl;
import java.util.Arrays;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class StripWordElementsFilter
extends ExtendedXMLFilterImpl {
    protected Set<String> elementsToStripSet;
    protected XMLSentenceMelder sentenceMelder = null;
    protected QueueStack<String> stripElementStack = new QueueStack();
    protected boolean processingWord;

    public StripWordElementsFilter(XMLReader reader, String elementsToStrip, XMLSentenceMelder sentenceMelder) {
        super(reader);
        this.elementsToStripSet = SetFactory.createNewSet();
        this.elementsToStripSet.addAll(Arrays.asList(StringUtils.makeTokenArray(elementsToStrip)));
        this.processingWord = false;
    }

    public StripWordElementsFilter(XMLReader reader, String elementsToStrip) {
        this(reader, elementsToStrip, null);
    }

    public void setSentenceMelder(XMLSentenceMelder sentenceMelder) {
        this.sentenceMelder = sentenceMelder;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.elementsToStripSet.contains(localName)) {
            this.stripElementStack.push(localName);
        }
        this.processingWord = false;
        if (this.stripElementStack.size() > 0) {
            if (this.sentenceMelder != null) {
                this.sentenceMelder.setEmitXMLWrapperForBlank(false);
            }
            if (qName.equalsIgnoreCase("w") || qName.equalsIgnoreCase("pc") || qName.equalsIgnoreCase("c")) {
                this.processingWord = true;
            } else {
                super.startElement(uri, localName, qName, atts);
            }
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stripElementStack.size() > 0) {
            if (this.processingWord) {
                super.characters(ch, start, length);
            }
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.elementsToStripSet.contains(localName)) {
            this.stripElementStack.pop();
        }
        if (this.stripElementStack.size() > 0) {
            if (!this.processingWord) {
                super.endElement(uri, localName, qName);
            }
        } else {
            super.endElement(uri, localName, qName);
        }
        this.processingWord = false;
        if (this.stripElementStack.size() == 0 && this.sentenceMelder != null) {
            this.sentenceMelder.setEmitXMLWrapperForBlank(true);
        }
    }
}

