/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.DefaultMorphAdornerXMLWriter;
import edu.northwestern.at.morphadorner.MorphAdornerXMLWriter;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class MorphAdornerXMLWriterFactory {
    public static MorphAdornerXMLWriter newMorphAdornerXMLWriter() {
        String className = System.getProperty("morphadornerxmlwriter.class");
        if (className == null) {
            className = "DefaultMorphAdornerXMLWriter";
        }
        return MorphAdornerXMLWriterFactory.newMorphAdornerXMLWriter(className);
    }

    public static MorphAdornerXMLWriter newMorphAdornerXMLWriter(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("morphadornerxmlwriter.class");
        }
        if (className == null) {
            className = "DefaultMorphAdornerXMLWriter";
        }
        return MorphAdornerXMLWriterFactory.newMorphAdornerXMLWriter(className);
    }

    public static MorphAdornerXMLWriter newMorphAdornerXMLWriter(String className) {
        MorphAdornerXMLWriter xmlWriter = null;
        try {
            xmlWriter = (MorphAdornerXMLWriter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(MorphAdornerXMLWriterFactory.class.getName()) + "." + className;
            try {
                xmlWriter = (MorphAdornerXMLWriter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create XML writer of class " + fixedClassName + ", using default.");
                xmlWriter = new DefaultMorphAdornerXMLWriter();
            }
        }
        return xmlWriter;
    }
}

