/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import com.megginson.sax.XMLWriter;
import edu.northwestern.at.morphadorner.IDFixerFilter;
import edu.northwestern.at.morphadorner.MorphAdorner;
import edu.northwestern.at.morphadorner.MorphAdornerLogger;
import edu.northwestern.at.morphadorner.MorphAdornerSettings;
import edu.northwestern.at.morphadorner.MorphAdornerUtils;
import edu.northwestern.at.morphadorner.MorphAdornerXMLWriter;
import edu.northwestern.at.morphadorner.SentenceAndWordNumber;
import edu.northwestern.at.morphadorner.SentenceNumberAdder;
import edu.northwestern.at.morphadorner.StripWordElementsFilter;
import edu.northwestern.at.morphadorner.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.PatternReplacer;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.xml.IndentingXMLWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultMorphAdornerXMLWriter
implements MorphAdornerXMLWriter {
    protected SortedArrayList<SentenceAndWordNumber> sortedWords = new SortedArrayList();
    protected XMLWriter writer;

    @Override
    public void writeXML(String inFile, String outFile, int maxID, PartOfSpeechTags posTags, Map<Integer, Integer> splitWords, int totalWords, int totalPageBreaks, MorphAdorner adorner, boolean tokenizingOnly) throws IOException, SAXException {
        MorphAdornerSettings settings = adorner.morphAdornerSettings;
        MorphAdornerLogger logger = adorner.morphAdornerLogger;
        XMLReader reader = XMLReaderFactory.createXMLReader();
        IDFixerFilter idFilter = new IDFixerFilter(reader, posTags, outFile, maxID, this.sortedWords, splitWords, totalWords, totalPageBreaks, settings, tokenizingOnly);
        boolean twoStep = !tokenizingOnly && (settings.outputSentenceBoundaryMilestones || settings.outputSentenceNumber || settings.outputWordNumber);
        String tempFileName = "";
        if (twoStep) {
            File tempFile = File.createTempFile("mad", null);
            tempFile.deleteOnExit();
            tempFileName = tempFile.getAbsolutePath();
            logger.println("Using_two_step_output");
        }
        StringWriter outputStreamWriter = new StringWriter();
        StripWordElementsFilter stripFilter = new StripWordElementsFilter(idFilter, settings.disallowWordElementsIn);
        this.writer = new IndentingXMLWriter(stripFilter, outputStreamWriter);
        ((IndentingXMLWriter)this.writer).setIndentStep(2);
        this.writer.setOutputCharsAsIs(true);
        this.writer.setDoctype(settings.xmlDoctypeName, settings.xmlDoctypeSystem);
        idFilter.setWriter(this.writer);
        stripFilter.setSentenceMelder(idFilter.getSentenceMelder());
        long startTime = System.currentTimeMillis();
        this.writer.parse(inFile);
        PatternReplacer replacer = new PatternReplacer("(\\s+)<unclear>(\\s+)<c> </c>", "$1<c> </c>$1<unclear>");
        String outputText = replacer.replace(outputStreamWriter.toString());
        replacer = new PatternReplacer("(\\s+)<hi(.*?)>(\\s+)<c> </c>", "$1<c> </c>$1<hi$2>");
        outputText = replacer.replace(outputText);
        String outputFileName = twoStep ? tempFileName : outFile;
        FileUtils.writeTextFile(new File(outputFileName), false, outputText, "utf-8");
        if (twoStep) {
            logger.println("First_output_step_completed", MorphAdornerUtils.durationString(adorner.morphAdornerSettings, startTime));
        }
        try {
            outputStreamWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (twoStep) {
            startTime = System.currentTimeMillis();
            this.getWordAndSentenceNumbers(settings);
            new SentenceNumberAdder(tempFileName, outFile, this.sortedWords, settings);
            FileUtils.deleteFile(tempFileName);
            logger.println("Second_output_step_completed", MorphAdornerUtils.durationString(adorner.morphAdornerSettings, startTime));
        }
    }

    protected void getWordAndSentenceNumbers(MorphAdornerSettings settings) {
        int sentenceNumber = 0;
        int wordNumber = 0;
        int runningWordNumber = 0;
        for (int i = 0; i < this.sortedWords.size(); ++i) {
            SentenceAndWordNumber swn = (SentenceAndWordNumber)this.sortedWords.get(i);
            if (swn.isFirstPart()) {
                if (wordNumber == 0) {
                    ++sentenceNumber;
                }
                ++wordNumber;
                ++runningWordNumber;
            }
            swn.setSentenceAndWordNumber(sentenceNumber, settings.outputRunningWordNumbers ? runningWordNumber : wordNumber);
            if (!swn.getEOS()) continue;
            wordNumber = 0;
        }
    }
}

