/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.MorphAdornerSettings;
import edu.northwestern.at.morphadorner.WordAttributeNames;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWord;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWordFilter;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.xml.ExtendedXMLFilterImpl;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class AddWordAttributesFilter
extends ExtendedXMLFilterImpl {
    protected ExtendedAdornedWordFilter wordInfoFilter;
    protected boolean outputNonredundantAttributesOnly = false;
    protected boolean outputNonredundantTokenAttribute = false;
    protected boolean outputNonredundantPartAttribute = false;
    protected boolean outputNonredundantEosAttribute = false;
    protected boolean outputEosAttribute = false;
    protected boolean outputWhitespace = true;
    protected boolean outputWordNumber = false;
    protected boolean outputSentenceNumber = false;
    protected boolean outputWordOrdinal = false;
    protected String idAttrName = WordAttributeNames.id;
    protected MorphAdornerSettings morphAdornerSettings = null;

    public AddWordAttributesFilter(XMLReader reader, ExtendedAdornedWordFilter wordInfoFilter, MorphAdornerSettings morphAdornerSettings) {
        super(reader);
        this.wordInfoFilter = wordInfoFilter;
        this.morphAdornerSettings = morphAdornerSettings;
        this.idAttrName = morphAdornerSettings.xgOptions.getIdArgumentName();
        this.outputNonredundantAttributesOnly = morphAdornerSettings.outputNonredundantAttributesOnly;
        this.outputNonredundantTokenAttribute = morphAdornerSettings.outputNonredundantTokenAttribute;
        this.outputNonredundantPartAttribute = morphAdornerSettings.outputNonredundantPartAttribute;
        this.outputEosAttribute = morphAdornerSettings.outputEOSFlag;
        this.outputNonredundantEosAttribute = morphAdornerSettings.outputNonredundantEosAttribute;
        this.outputWhitespace = morphAdornerSettings.outputWhitespaceElements;
        this.outputSentenceNumber = morphAdornerSettings.outputSentenceNumber;
        this.outputWordNumber = morphAdornerSettings.outputWordNumber;
        this.outputWordOrdinal = morphAdornerSettings.outputWordOrdinal;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equalsIgnoreCase("w") || qName.equalsIgnoreCase("pc")) {
            String label;
            String type;
            String rend;
            Map<String, String> newAtts = MapFactory.createNewSortedMap();
            String id = atts.getValue(this.idAttrName);
            newAtts.put(this.idAttrName, id);
            ExtendedAdornedWord wordInfo = this.wordInfoFilter.getExtendedAdornedWord(id);
            String tok = wordInfo.getToken();
            String spe = wordInfo.getSpelling();
            String pos = wordInfo.getPartsOfSpeech();
            boolean eos = wordInfo.getEOS();
            String lem = wordInfo.getLemmata();
            String reg = wordInfo.getStandardSpelling();
            int ord = wordInfo.getOrd();
            String part = wordInfo.getPart();
            String wordText = wordInfo.getWordText();
            String unit = atts.getValue("unit");
            if (unit != null) {
                newAtts.put("unit", unit);
            }
            if ((rend = atts.getValue("rend")) != null && rend.length() > 0) {
                newAtts.put("rend", rend);
            }
            if ((type = atts.getValue("type")) != null && type.length() > 0) {
                newAtts.put("type", type);
            }
            if ((label = atts.getValue(WordAttributeNames.label)) != null && label.length() > 0) {
                newAtts.put(WordAttributeNames.label, label);
            }
            if (this.outputSentenceNumber) {
                newAtts.put(WordAttributeNames.sn, wordInfo.getSentenceNumber() + "");
            }
            if (this.outputWordNumber) {
                newAtts.put(WordAttributeNames.wn, wordInfo.getWordNumber() + "");
            }
            if (this.morphAdornerSettings.outputEOSFlag) {
                newAtts.put(WordAttributeNames.eos, eos ? "1" : "0");
            }
            if (this.morphAdornerSettings.outputLemma) {
                newAtts.put(WordAttributeNames.lem, lem);
            }
            if (this.morphAdornerSettings.outputPartOfSpeech) {
                newAtts.put(WordAttributeNames.pos, pos);
            }
            if (this.morphAdornerSettings.outputStandardSpelling) {
                newAtts.put(WordAttributeNames.reg, reg);
            }
            if (this.morphAdornerSettings.outputSpelling) {
                newAtts.put(WordAttributeNames.spe, spe);
            }
            if (this.morphAdornerSettings.outputOriginalToken) {
                newAtts.put(WordAttributeNames.tok, tok);
            }
            newAtts.put(WordAttributeNames.part, part);
            if (this.outputNonredundantAttributesOnly || tok.length() == 0) {
                if (!eos || unit.equals("sentence")) {
                    newAtts.remove(WordAttributeNames.eos);
                }
                if (spe.equals(tok)) {
                    newAtts.remove(WordAttributeNames.spe);
                }
                if (lem.equals(spe)) {
                    newAtts.remove(WordAttributeNames.lem);
                }
                if (pos.equals(spe) || tok.length() == 0) {
                    newAtts.remove(WordAttributeNames.pos);
                }
                if (reg.equals(spe)) {
                    newAtts.remove(WordAttributeNames.reg);
                }
                if (part != null && part.equals("N")) {
                    newAtts.remove(WordAttributeNames.part);
                }
                if (tok.equals(wordText)) {
                    newAtts.remove(WordAttributeNames.tok);
                }
            } else {
                if (this.outputNonredundantTokenAttribute && tok.equals(wordText)) {
                    newAtts.remove(WordAttributeNames.tok);
                }
                if (this.outputNonredundantPartAttribute && part.equals("N")) {
                    newAtts.remove(WordAttributeNames.part);
                }
                if (this.outputNonredundantEosAttribute && (!eos || unit != null)) {
                    newAtts.remove(WordAttributeNames.eos);
                }
            }
            AttributesImpl newAttributes = new AttributesImpl();
            for (String attName : newAtts.keySet()) {
                this.setAttributeValue(newAttributes, attName, (String)newAtts.get(attName));
            }
            super.startElement(uri, localName, qName, newAttributes);
        } else if (qName.equalsIgnoreCase("c")) {
            AttributesImpl newAtts = new AttributesImpl(atts);
            this.removeAttribute(newAtts, WordAttributeNames.part);
            if (this.outputWhitespace) {
                super.startElement(uri, localName, qName, newAtts);
            }
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("c")) {
            if (this.outputWhitespace) {
                super.endElement(uri, localName, qName);
            }
        } else {
            super.endElement(uri, localName, qName);
        }
    }
}

