/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import com.rmtheis.langdetect.profile.AF;
import com.rmtheis.langdetect.profile.AN;
import com.rmtheis.langdetect.profile.ANG;
import com.rmtheis.langdetect.profile.AR;
import com.rmtheis.langdetect.profile.AST;
import com.rmtheis.langdetect.profile.BE;
import com.rmtheis.langdetect.profile.BG;
import com.rmtheis.langdetect.profile.BN;
import com.rmtheis.langdetect.profile.BR;
import com.rmtheis.langdetect.profile.CA;
import com.rmtheis.langdetect.profile.CLangProfile;
import com.rmtheis.langdetect.profile.CS;
import com.rmtheis.langdetect.profile.CY;
import com.rmtheis.langdetect.profile.DA;
import com.rmtheis.langdetect.profile.DE;
import com.rmtheis.langdetect.profile.EL;
import com.rmtheis.langdetect.profile.EN;
import com.rmtheis.langdetect.profile.EO;
import com.rmtheis.langdetect.profile.ES;
import com.rmtheis.langdetect.profile.ET;
import com.rmtheis.langdetect.profile.EU;
import com.rmtheis.langdetect.profile.FA;
import com.rmtheis.langdetect.profile.FI;
import com.rmtheis.langdetect.profile.FR;
import com.rmtheis.langdetect.profile.GA;
import com.rmtheis.langdetect.profile.GL;
import com.rmtheis.langdetect.profile.GU;
import com.rmtheis.langdetect.profile.HE;
import com.rmtheis.langdetect.profile.HI;
import com.rmtheis.langdetect.profile.HR;
import com.rmtheis.langdetect.profile.HT;
import com.rmtheis.langdetect.profile.HU;
import com.rmtheis.langdetect.profile.ID;
import com.rmtheis.langdetect.profile.IS;
import com.rmtheis.langdetect.profile.IT;
import com.rmtheis.langdetect.profile.JA;
import com.rmtheis.langdetect.profile.KN;
import com.rmtheis.langdetect.profile.KO;
import com.rmtheis.langdetect.profile.LA;
import com.rmtheis.langdetect.profile.LT;
import com.rmtheis.langdetect.profile.LV;
import com.rmtheis.langdetect.profile.MK;
import com.rmtheis.langdetect.profile.ML;
import com.rmtheis.langdetect.profile.MR;
import com.rmtheis.langdetect.profile.MS;
import com.rmtheis.langdetect.profile.MT;
import com.rmtheis.langdetect.profile.NE;
import com.rmtheis.langdetect.profile.NL;
import com.rmtheis.langdetect.profile.NO;
import com.rmtheis.langdetect.profile.OC;
import com.rmtheis.langdetect.profile.PA;
import com.rmtheis.langdetect.profile.PL;
import com.rmtheis.langdetect.profile.PT;
import com.rmtheis.langdetect.profile.RO;
import com.rmtheis.langdetect.profile.RU;
import com.rmtheis.langdetect.profile.SCO;
import com.rmtheis.langdetect.profile.SK;
import com.rmtheis.langdetect.profile.SL;
import com.rmtheis.langdetect.profile.SO;
import com.rmtheis.langdetect.profile.SQ;
import com.rmtheis.langdetect.profile.SR;
import com.rmtheis.langdetect.profile.SV;
import com.rmtheis.langdetect.profile.SW;
import com.rmtheis.langdetect.profile.TA;
import com.rmtheis.langdetect.profile.TE;
import com.rmtheis.langdetect.profile.TH;
import com.rmtheis.langdetect.profile.TL;
import com.rmtheis.langdetect.profile.TR;
import com.rmtheis.langdetect.profile.UK;
import com.rmtheis.langdetect.profile.UR;
import com.rmtheis.langdetect.profile.VI;
import com.rmtheis.langdetect.profile.YI;
import com.rmtheis.langdetect.profile.ZHCN;
import com.rmtheis.langdetect.profile.ZHTW;
import edu.northwestern.at.utils.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DetectorFactory {
    public HashMap<String, double[]> wordLangProbMap = new HashMap();
    public ArrayList<String> langlist = new ArrayList();
    private static List<LangProfile> profilelist;
    private static boolean isProfileListLoaded;
    public Long seed = null;
    private static DetectorFactory instance_;

    private DetectorFactory() {
        profilelist = Arrays.asList(new AF().getLangProfile(), new SQ().getLangProfile(), new AR().getLangProfile(), new AN().getLangProfile(), new ANG().getLangProfile(), new AST().getLangProfile(), new EU().getLangProfile(), new BE().getLangProfile(), new BN().getLangProfile(), new BR().getLangProfile(), new BG().getLangProfile(), new CA().getLangProfile(), new ZHCN().getLangProfile(), new ZHTW().getLangProfile(), new HR().getLangProfile(), new CS().getLangProfile(), new DA().getLangProfile(), new NL().getLangProfile(), new EN().getLangProfile(), new EO().getLangProfile(), new ET().getLangProfile(), new FI().getLangProfile(), new FR().getLangProfile(), new GL().getLangProfile(), new DE().getLangProfile(), new EL().getLangProfile(), new GU().getLangProfile(), new HT().getLangProfile(), new HE().getLangProfile(), new HI().getLangProfile(), new HU().getLangProfile(), new IS().getLangProfile(), new ID().getLangProfile(), new GA().getLangProfile(), new IT().getLangProfile(), new JA().getLangProfile(), new KN().getLangProfile(), new KO().getLangProfile(), new LA().getLangProfile(), new LV().getLangProfile(), new LT().getLangProfile(), new MK().getLangProfile(), new MS().getLangProfile(), new ML().getLangProfile(), new MT().getLangProfile(), new MR().getLangProfile(), new NE().getLangProfile(), new NO().getLangProfile(), new OC().getLangProfile(), new PA().getLangProfile(), new FA().getLangProfile(), new PL().getLangProfile(), new PT().getLangProfile(), new RO().getLangProfile(), new RU().getLangProfile(), new SCO().getLangProfile(), new SR().getLangProfile(), new SK().getLangProfile(), new SL().getLangProfile(), new SO().getLangProfile(), new ES().getLangProfile(), new SW().getLangProfile(), new SV().getLangProfile(), new TL().getLangProfile(), new TA().getLangProfile(), new TE().getLangProfile(), new TH().getLangProfile(), new TR().getLangProfile(), new UK().getLangProfile(), new UR().getLangProfile(), new VI().getLangProfile(), new CY().getLangProfile(), new YI().getLangProfile());
    }

    public static void loadProfiles(List<LangProfile> profiles) {
        int index = 0;
        int langsize = profiles.size();
        for (LangProfile profile : profiles) {
            DetectorFactory.addProfile(profile, index, langsize);
            ++index;
        }
    }

    public static void loadProfilesByName(List<String> profileNames) {
        ArrayList<LangProfile> profiles = new ArrayList<LangProfile>();
        for (int i = 0; i < profileNames.size(); ++i) {
            CLangProfile cProfile = DetectorFactory.getLanguageProfile(profileNames.get(i));
            if (cProfile == null) continue;
            profiles.add(cProfile.getLangProfile());
        }
        DetectorFactory.loadProfiles(profiles);
    }

    static void addProfile(LangProfile profile, int index, int langsize) {
        String lang = profile.name;
        DetectorFactory.instance_.langlist.add(lang);
        for (String word : profile.freq.keySet()) {
            double prob;
            int length;
            if (!DetectorFactory.instance_.wordLangProbMap.containsKey(word)) {
                DetectorFactory.instance_.wordLangProbMap.put(word, new double[langsize]);
            }
            if ((length = word.length()) < 1 || length > 3) continue;
            DetectorFactory.instance_.wordLangProbMap.get((Object)word)[index] = prob = profile.freq.get(word).doubleValue() / (double)profile.n_words[length - 1];
        }
    }

    public static void clear() {
        DetectorFactory.instance_.langlist.clear();
        DetectorFactory.instance_.wordLangProbMap.clear();
    }

    public static Detector create() {
        return DetectorFactory.createDetector();
    }

    public static Detector create(double alpha) throws LangDetectException {
        Detector detector = DetectorFactory.createDetector();
        detector.setAlpha(alpha);
        return detector;
    }

    private static Detector createDetector() {
        Detector detector = new Detector(instance_);
        if (!isProfileListLoaded) {
            DetectorFactory.loadProfiles(profilelist);
            isProfileListLoaded = true;
        }
        return detector;
    }

    public static void setSeed(long seed) {
        DetectorFactory.instance_.seed = seed;
    }

    public static final List<String> getLangList() {
        return Collections.unmodifiableList(DetectorFactory.instance_.langlist);
    }

    protected static CLangProfile getLanguageProfile(String profileName) {
        CLangProfile langProfile = null;
        String className = ClassUtils.packageName(CLangProfile.class.getName()) + "." + profileName;
        try {
            langProfile = (CLangProfile)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return langProfile;
    }

    static {
        isProfileListLoaded = false;
        instance_ = new DetectorFactory();
    }
}

